/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.misc;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.misc.CreativeGeneratorTile;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class CreativeGeneratorBlock
extends QPBlock
implements EntityBlock {
    public static final String NAME = "creative_generator";

    public CreativeGeneratorBlock() {
        super(BlockBehaviour.Properties.of((Material)Material.METAL).strength(1.0f, 1.0f).sound(SoundType.STONE), NAME);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return Holder.CREATIVE_GENERATOR_TYPE.create(pos, state);
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.isShiftKeyDown()) {
            if (!world.isClientSide) {
                world.getBlockEntity(pos, Holder.CREATIVE_GENERATOR_TYPE).ifPresent(o -> NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)o, (BlockPos)pos));
            }
            return InteractionResult.SUCCESS;
        }
        return super.use(state, world, pos, player, hand, hit);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return world.isClientSide ? null : CreativeGeneratorBlock.checkType(type, Holder.CREATIVE_GENERATOR_TYPE, CreativeGeneratorTile.TICKER);
    }

    public void appendHoverText(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag options) {
        super.appendHoverText(stack, world, tooltip, options);
        tooltip.add((Component)new TextComponent("Works only for Quarry"));
    }
}

