/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.misc;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.yogpc.qp.machines.misc.CreativeGeneratorMenu;
import com.yogpc.qp.machines.misc.CreativeGeneratorSyncMessage;
import com.yogpc.qp.packet.PacketHandler;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CreativeGeneratorScreen
extends AbstractContainerScreen<CreativeGeneratorMenu> {
    private static final ResourceLocation LOCATION = new ResourceLocation("quarryplus", "textures/gui/adv_pump.png");
    EditBox textFieldWidget;

    public CreativeGeneratorScreen(CreativeGeneratorMenu c, Inventory inventory, Component component) {
        super((AbstractContainerMenu)c, inventory, component);
    }

    public void render(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.renderBackground(matrices);
        super.render(matrices, mouseX, mouseY, delta);
        this.renderTooltip(matrices, mouseX, mouseY);
    }

    protected void renderBg(PoseStack matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LOCATION);
        this.blit(matrices, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderLabels(PoseStack matrices, int mouseX, int mouseY) {
        super.renderLabels(matrices, mouseX, mouseY);
        this.font.draw(matrices, ((CreativeGeneratorMenu)this.getMenu()).tile.sendEnergy / 1000000000L + " FE/t", (float)this.titleLabelX, (float)(this.titleLabelY + 20), 0x404040);
    }

    protected void init() {
        super.init();
        this.textFieldWidget = new EditBox(this.font, this.getGuiLeft() + 8, this.getGuiTop() + 40, 130, 18, (Component)new TextComponent("EnergyField"));
        this.textFieldWidget.setResponder(this::changeEnergy);
        this.textFieldWidget.setFilter(CreativeGeneratorScreen::canConvert);
        this.textFieldWidget.setCanLoseFocus(true);
        this.addRenderableWidget((GuiEventListener)this.textFieldWidget);
        this.textFieldWidget.setValue(String.valueOf(((CreativeGeneratorMenu)this.getMenu()).tile.sendEnergy));
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (keyCode == 256 || !this.textFieldWidget.isFocused() && this.getMinecraft().options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        if (this.textFieldWidget.keyPressed(keyCode, scanCode, modifiers) || this.textFieldWidget.canConsumeInput()) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void changeEnergy(String s) {
        try {
            long e = Long.parseLong(s);
            if (e >= 0L) {
                ((CreativeGeneratorMenu)this.getMenu()).tile.sendEnergy = e;
                PacketHandler.sendToServer(new CreativeGeneratorSyncMessage(((CreativeGeneratorMenu)this.getMenu()).tile));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static boolean canConvert(String s) {
        try {
            return Long.parseLong(s) >= 0L;
        }
        catch (NumberFormatException ignore) {
            return false;
        }
    }
}

