/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.misc;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.misc.CreativeGeneratorMenu;
import com.yogpc.qp.utils.MapMulti;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;

public class CreativeGeneratorTile
extends PowerTile
implements MenuProvider {
    long sendEnergy = 100000000000000L;
    static final BlockEntityTicker<CreativeGeneratorTile> TICKER = (world, pos, state, tile) -> Arrays.stream(Direction.values()).map(arg_0 -> ((BlockPos)pos).relative(arg_0)).map(arg_0 -> ((Level)world).getBlockEntity(arg_0)).mapMulti(MapMulti.cast(PowerTile.class)).forEach(t -> t.addEnergy(tile.sendEnergy, false));

    public CreativeGeneratorTile(BlockPos pos, BlockState state) {
        super(Holder.CREATIVE_GENERATOR_TYPE, pos, state);
        this.setEnergy(this.getMaxEnergy(), false);
    }

    @Override
    public void saveNbtData(CompoundTag nbt) {
        nbt.putLong("sendEnergy", this.sendEnergy);
    }

    @Override
    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.sendEnergy = nbt.getLong("sendEnergy");
    }

    public Component getDisplayName() {
        return this.getBlockState().getBlock().getName();
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new CreativeGeneratorMenu(id, player, this.getBlockPos());
    }
}

