/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.misc;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.yogpc.qp.machines.misc.YAccessor;
import com.yogpc.qp.machines.misc.YSetterContainer;
import com.yogpc.qp.packet.PacketHandler;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class YSetterScreen
extends AbstractContainerScreen<YSetterContainer> {
    private static final ResourceLocation LOCATION = new ResourceLocation("quarryplus", "textures/gui/adv_pump.png");
    private static final int tp = 15;

    public YSetterScreen(YSetterContainer handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
    }

    public void render(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.renderBackground(matrices);
        super.render(matrices, mouseX, mouseY, delta);
        this.renderTooltip(matrices, mouseX, mouseY);
    }

    protected void renderLabels(PoseStack matrices, int mouseX, int mouseY) {
        super.renderLabels(matrices, mouseX, mouseY);
        if (((YSetterContainer)this.getMenu()).yAccessor != null) {
            String level = String.valueOf(((YSetterContainer)this.getMenu()).yAccessor.getDigMinY() + 1);
            this.font.draw(matrices, level, ((float)this.imageWidth - (float)this.font.width(level)) / 2.0f, 38.0f, 0x404040);
        }
    }

    protected void renderBg(PoseStack matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LOCATION);
        this.blit(matrices, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void init() {
        super.init();
        int width = 40;
        this.addRenderableWidget((GuiEventListener)new Button(this.getGuiLeft() + this.imageWidth / 2 - 20, this.getGuiTop() + 15, 40, 20, (Component)new TextComponent("+"), b -> this.changeDigY(true)));
        this.addRenderableWidget((GuiEventListener)new Button(this.getGuiLeft() + this.imageWidth / 2 - 20, this.getGuiTop() + 15 + 33, 40, 20, (Component)new TextComponent("-"), b -> this.changeDigY(false)));
    }

    private void changeDigY(boolean plus) {
        YAccessor accessor = ((YSetterContainer)this.getMenu()).yAccessor;
        if (accessor != null) {
            int n = Screen.hasShiftDown() ? 16 : (Screen.hasControlDown() ? 4 : 1);
            int count = (plus ? 1 : -1) * n;
            int topLimit = accessor.getLimitTop();
            if (count + accessor.getDigMinY() < topLimit) {
                accessor.setDigMinY(count + accessor.getDigMinY());
                PacketHandler.sendToServer(accessor.makeMessage());
            }
        }
    }
}

