/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.module;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QPItem;
import com.yogpc.qp.machines.module.ModuleInventory;
import com.yogpc.qp.machines.module.QuarryModule;
import com.yogpc.qp.machines.module.QuarryModuleProvider;
import com.yogpc.qp.utils.MapMulti;
import java.util.Comparator;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import org.jetbrains.annotations.Nullable;

public class EnergyModuleItem
extends QPItem
implements QuarryModuleProvider.Item {
    public static final ResourceLocation LOCATION = new ResourceLocation("quarryplus", "energy_module");
    private final int energy;

    public EnergyModuleItem(int energy, String path) {
        super(new Item.Properties().tab(Holder.TAB));
        this.energy = energy;
        this.setRegistryName("quarryplus", path);
    }

    @Override
    public EnergyModule getModule(ItemStack stack) {
        if (this.energy > 0) {
            try {
                int energy = Math.multiplyExact(this.energy, stack.getCount());
                return new EnergyModule(energy);
            }
            catch (ArithmeticException ignore) {
                return new EnergyModule(Integer.MAX_VALUE);
            }
        }
        return new EnergyModule(0);
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, level, list, flag);
        list.add((Component)new TextComponent("Can be stacked to increase power."));
    }

    public static <T extends PowerTile> BlockEntityTicker<T> energyModuleTicker() {
        return (w, p, s, blockEntity) -> ((ModuleInventory.HasModuleInventory)((Object)blockEntity)).getLoadedModules().stream().mapMulti(MapMulti.cast(EnergyModule.class)).max(Comparator.comparingInt(EnergyModule::energy)).ifPresent(e -> blockEntity.addEnergy((long)e.energy * 1000000000L, false));
    }

    public record EnergyModule(int energy) implements QuarryModule
    {
        @Override
        public ResourceLocation moduleId() {
            return LOCATION;
        }
    }
}

