/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.module;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.QPItem;
import com.yogpc.qp.machines.module.ExpModule;
import com.yogpc.qp.machines.module.QuarryModule;
import com.yogpc.qp.machines.module.QuarryModuleProvider;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpModuleItem
extends QPItem
implements QuarryModuleProvider.Item {
    public static final String NAME = "exp_module";
    public static final String KEY_AMOUNT = "amount";

    public ExpModuleItem() {
        super(new Item.Properties().tab(Holder.TAB).stacksTo(1));
        this.setRegistryName("quarryplus", NAME);
    }

    @Override
    public QuarryModule getModule(@NotNull ItemStack stack) {
        return new ExpItemModule(stack);
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, level, list, flag);
        Stream.ofNullable(stack.getTag()).mapToInt(t -> t.getInt(KEY_AMOUNT)).filter(i -> i >= 0).mapToObj(i -> "Exp: " + i).map(TextComponent::new).forEach(list::add);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getTag() != null) {
            int exp = stack.getTag().getInt(KEY_AMOUNT);
            if (!level.isClientSide) {
                player.displayClientMessage((Component)new TranslatableComponent("quarryplus.chat.give_exp", new Object[]{exp}), false);
                player.giveExperiencePoints(exp);
            }
            stack.removeTagKey(KEY_AMOUNT);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    static class ExpItemModule
    extends ExpModule {
        private final ItemStack stack;

        ExpItemModule(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public void addExp(int amount) {
            if (amount == 0) {
                return;
            }
            CompoundTag tag = this.stack.getOrCreateTag();
            int pre = tag.getInt(ExpModuleItem.KEY_AMOUNT);
            tag.putInt(ExpModuleItem.KEY_AMOUNT, pre + amount);
        }

        @Override
        public int getExp() {
            if (!this.stack.hasTag()) {
                return 0;
            }
            assert (this.stack.getTag() != null);
            return this.stack.getTag().getInt(ExpModuleItem.KEY_AMOUNT);
        }
    }
}

