/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.module;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.module.ExpPumpTile;
import com.yogpc.qp.machines.module.QuarryModule;
import com.yogpc.qp.machines.module.QuarryModuleProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class ExpPumpBlock
extends QPBlock
implements EntityBlock,
QuarryModuleProvider.Block {
    public static final String NAME = "exp_pump";

    public ExpPumpBlock() {
        super(BlockBehaviour.Properties.of((Material)Material.METAL).strength(3.0f), NAME);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WORKING, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return Holder.EXP_PUMP_TYPE.create(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WORKING});
    }

    @Override
    public QuarryModule getModule(@NotNull Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ExpPumpTile) {
            ExpPumpTile expPump = (ExpPumpTile)blockEntity;
            return expPump.getModule();
        }
        return QuarryModule.Constant.DUMMY;
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ExpPumpTile expPump;
        BlockEntity blockEntity;
        if (!QuarryPlus.config.enableMap.enabled(NAME)) {
            if (!level.isClientSide) {
                player.displayClientMessage((Component)new TranslatableComponent("quarryplus.chat.disable_message", new Object[]{this.getName()}), true);
            }
            return InteractionResult.SUCCESS;
        }
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof ExpPumpTile && (expPump = (ExpPumpTile)blockEntity).getModule().getExp() > 0) {
            player.giveExperiencePoints(expPump.getModule().getExp());
            player.displayClientMessage((Component)new TranslatableComponent("quarryplus.chat.give_exp", new Object[]{expPump.getModule().getExp()}), false);
            expPump.getModule().setExp(0, false);
        }
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (state.getBlock() != newState.getBlock()) {
            ExpPumpTile expPump;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof ExpPumpTile && (expPump = (ExpPumpTile)blockEntity).getModule().getExp() > 0) {
                state.getBlock().popExperience((ServerLevel)level, pos, expPump.getModule().getExp());
            }
            super.onRemove(state, level, pos, newState, moved);
        }
    }
}

