/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.module;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.module.ExpModule;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ExpPumpTile
extends BlockEntity
implements CheckerLog {
    private final ExpBlockModule module = new ExpBlockModule(this);

    public ExpPumpTile(BlockPos pos, BlockState state) {
        super(Holder.EXP_PUMP_TYPE, pos, state);
    }

    protected void saveAdditional(CompoundTag tag) {
        tag.putInt("exp", this.module.getExp());
        super.saveAdditional(tag);
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.module.setExp(tag.getInt("exp"), true);
    }

    ExpBlockModule getModule() {
        return this.module;
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        return Stream.of("Exp: " + this.module.getExp()).map(TextComponent::new).toList();
    }

    static class ExpBlockModule
    extends ExpModule {
        private final ExpPumpTile parent;
        private int exp = 0;

        ExpBlockModule(ExpPumpTile parent) {
            this.parent = parent;
        }

        @Override
        public void addExp(int amount) {
            this.exp += amount;
            if (this.parent.level != null && !((Boolean)this.parent.getBlockState().getValue((Property)QPBlock.WORKING)).booleanValue()) {
                this.parent.level.setBlock(this.parent.getBlockPos(), (BlockState)this.parent.getBlockState().setValue((Property)QPBlock.WORKING, (Comparable)Boolean.valueOf(true)), 3);
            }
            this.parent.setChanged();
        }

        @Override
        public int getExp() {
            return this.exp;
        }

        void setExp(int exp, boolean loading) {
            this.exp = exp;
            if (!loading) {
                if (this.exp <= 0 && this.parent.level != null && ((Boolean)this.parent.getBlockState().getValue((Property)QPBlock.WORKING)).booleanValue()) {
                    this.parent.level.setBlock(this.parent.getBlockPos(), (BlockState)this.parent.getBlockState().setValue((Property)QPBlock.WORKING, (Comparable)Boolean.valueOf(false)), 3);
                }
                this.parent.setChanged();
            }
        }
    }
}

