/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.module;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.module.ModuleInventory;
import com.yogpc.qp.machines.module.ModuleLootFunctionSerializer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ModuleLootFunction
extends LootItemConditionalFunction {
    public static final LootItemConditionalFunction.Serializer<ModuleLootFunction> SERIALIZER = new ModuleLootFunctionSerializer();
    public static final String NAME = "drop_function_module";

    protected ModuleLootFunction(LootItemCondition[] conditions) {
        super(conditions);
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        BlockEntity blockEntity = (BlockEntity)context.getParam(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof ModuleInventory.HasModuleInventory) {
            ModuleInventory.HasModuleInventory moduleInventory = (ModuleInventory.HasModuleInventory)blockEntity;
            ModuleLootFunction.process(stack, moduleInventory);
        }
        return stack;
    }

    public LootItemFunctionType getType() {
        return Holder.MODULE_LOOT_TYPE;
    }

    public static void process(ItemStack stack, ModuleInventory.HasModuleInventory holder) {
        ModuleInventory moduleInventory = holder.getModuleInventory();
        if (!moduleInventory.isEmpty()) {
            CompoundTag blockTag = stack.getOrCreateTagElement("BlockEntityTag");
            blockTag.put("moduleInventory", (Tag)moduleInventory.serializeNBT());
        }
    }

    public static LootItemConditionalFunction.Builder<?> builder() {
        return LootItemConditionalFunction.simpleBuilder(ModuleLootFunction::new);
    }
}

