/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.module;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.QPItem;
import com.yogpc.qp.machines.module.ModuleInventory;
import com.yogpc.qp.machines.module.QuarryModuleProvider;
import com.yogpc.qp.machines.module.ReplacerModule;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplacerModuleItem
extends QPItem
implements QuarryModuleProvider.Item {
    public static final String NAME = "replacer_module";
    public static final String KEY_STATE = "state";

    public ReplacerModuleItem() {
        super(new Item.Properties().tab(Holder.TAB));
        this.setRegistryName("quarryplus", NAME);
    }

    @Override
    public ReplacerModule getModule(@NotNull ItemStack stack) {
        BlockState state = Optional.ofNullable(stack.getTagElement(KEY_STATE)).flatMap(this::getStateFromTag).orElse(Holder.BLOCK_DUMMY_REPLACER.defaultBlockState());
        return new ReplacerModule(state);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (!context.getLevel().isClientSide) {
            if (context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
                stack.removeTagKey(KEY_STATE);
                context.getPlayer().sendMessage((Component)new TextComponent("Replacer Module: Setting removed."), Util.NIL_UUID);
            } else {
                if (context.getLevel().getBlockEntity(context.getClickedPos()) instanceof ModuleInventory.HasModuleInventory) {
                    return InteractionResult.PASS;
                }
                BlockState state = context.getLevel().getBlockState(context.getClickedPos());
                if (ReplacerModule.rejects.stream().anyMatch(t -> t.test(state))) {
                    return InteractionResult.PASS;
                }
                BlockState.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)state).resultOrPartial(s -> {
                    stack.removeTagKey(KEY_STATE);
                    QuarryPlus.LOGGER.warn("Error in encoding state to NBT. {}, {}", (Object)state, s);
                }).ifPresent(stateTag -> stack.addTagElement(KEY_STATE, stateTag));
                if (context.getPlayer() != null) {
                    context.getPlayer().sendMessage((Component)new TranslatableComponent("Replacer Module: %s.", new Object[]{state.getBlock().getName()}), Util.NIL_UUID);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, level, list, flag);
        Optional.ofNullable(stack.getTagElement(KEY_STATE)).flatMap(tag -> BlockState.CODEC.parse((DynamicOps)NbtOps.INSTANCE, tag).result()).ifPresent(state -> {
            list.add((Component)state.getBlock().getName());
            state.getValues().forEach((k, v) -> list.add((Component)new TextComponent(String.format("  %s: %s", k.getName(), v))));
        });
    }

    Optional<BlockState> getStateFromTag(CompoundTag tag) {
        try {
            Predicate<BlockState> accept = ReplacerModule.rejects.stream().reduce(s -> false, Predicate::or).negate();
            DataResult result = BlockState.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag);
            return result.result().filter(accept);
        }
        catch (Exception e) {
            QuarryPlus.LOGGER.debug("Error in getting replace block of ReplacerModule.", (Throwable)e);
            return Optional.empty();
        }
    }
}

