/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.mover;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.mover.ContainerMover;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class BlockMover
extends QPBlock {
    public static final String NAME = "mover";
    public static final String GUI_ID = "quarryplus:gui_mover";

    public BlockMover() {
        super(BlockBehaviour.Properties.of((Material)Material.METAL).strength(1.2f), NAME);
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!QuarryPlus.config.enableMap.enabled(NAME)) {
            if (!level.isClientSide) {
                player.displayClientMessage((Component)new TranslatableComponent("quarryplus.chat.disable_message", new Object[]{this.getName()}), true);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (!player.isShiftKeyDown()) {
            if (!level.isClientSide) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new InteractionObject(pos, (Component)this.getName()), (BlockPos)pos);
            }
            return InteractionResult.SUCCESS;
        }
        return super.use(state, level, pos, player, hand, hit);
    }

    public void fillItemCategory(CreativeModeTab tab, NonNullList<ItemStack> stacks) {
        super.fillItemCategory(tab, stacks);
        ItemStack stack = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
        stack.enchant(Enchantments.BLOCK_EFFICIENCY, 5);
        stack.enchant(Enchantments.UNBREAKING, 3);
        stack.enchant(Enchantments.BLOCK_FORTUNE, 3);
        stacks.add((Object)stack);
        stack = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
        stack.enchant(Enchantments.BLOCK_EFFICIENCY, 5);
        stack.enchant(Enchantments.UNBREAKING, 3);
        stack.enchant(Enchantments.SILK_TOUCH, 1);
        stacks.add((Object)stack);
    }

    private record InteractionObject(BlockPos pos, Component name) implements MenuProvider
    {
        public Component getDisplayName() {
            return this.name;
        }

        public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
            return new ContainerMover(id, player, this.pos);
        }
    }
}

