/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.mover;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.EnchantableItem;
import com.yogpc.qp.machines.EnchantmentLevel;
import com.yogpc.qp.machines.mover.SlotMover;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class ContainerMover
extends AbstractContainerMenu {
    public final Container craftMatrix = new SimpleContainer(2){

        public void setChanged() {
            super.setChanged();
            ContainerMover.this.updateEnchantmentList();
        }
    };
    private final Level worldObj;
    List<Enchantment> movable = Collections.emptyList();
    @Nullable
    Enchantment selected = null;
    public final BlockPos pos;

    public ContainerMover(int id, Player player, BlockPos pos) {
        super(Holder.MOVER_MENU_TYPE, id);
        int col;
        Inventory inv = player.getInventory();
        this.worldObj = player.level;
        this.pos = pos;
        for (col = 0; col < 2; ++col) {
            this.addSlot(new SlotMover(this.craftMatrix, col, 8 + col * 144, 40));
        }
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)inv, col + row * 9 + 9, 8 + col * 18, 104 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)inv, col, 8 + col * 18, 162));
        }
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        if (!this.worldObj.isClientSide) {
            IntStream.range(0, this.craftMatrix.getContainerSize()).mapToObj(arg_0 -> ((Container)this.craftMatrix).removeItemNoUpdate(arg_0)).filter(Predicate.not(ItemStack::isEmpty)).forEach(arg_0 -> ((Inventory)playerIn.getInventory()).placeItemBackInInventory(arg_0));
        }
    }

    public boolean stillValid(Player playerIn) {
        return this.worldObj.getBlockState(this.pos).is((Block)Holder.BLOCK_MOVER) && playerIn.distanceToSqr(Vec3.atCenterOf((Vec3i)this.pos)) <= 64.0;
    }

    void updateEnchantmentList() {
        ItemStack from = this.craftMatrix.getItem(0);
        ItemStack to = this.craftMatrix.getItem(1);
        if (from.isEmpty() || to.isEmpty() || from.getEnchantmentTags().isEmpty() || !(to.getItem() instanceof EnchantableItem)) {
            this.movable = Collections.emptyList();
            this.selected = null;
        } else {
            List<Enchantment> newMovable = ContainerMover.getMovable(from, to, (EnchantableItem)to.getItem());
            if (newMovable.isEmpty()) {
                this.selected = null;
            } else if (!newMovable.contains(this.selected)) {
                this.selected = newMovable.get(0);
            }
            this.movable = newMovable;
        }
    }

    @VisibleForTesting
    static List<Enchantment> getMovable(ItemStack from, ItemStack to, Predicate<Enchantment> predicate) {
        Map given = EnchantmentHelper.getEnchantments((ItemStack)to);
        return EnchantmentLevel.fromItem(from).stream().map(EnchantmentLevel::enchantment).filter(e -> ContainerMover.canMoveEnchantment(predicate, given, e)).toList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    static boolean canMoveEnchantment(@Nullable Predicate<Enchantment> predicate, Map<Enchantment, Integer> given, Enchantment toMove) {
        if (predicate != null) {
            if (!predicate.test(toMove)) return false;
        }
        if (given.getOrDefault(toMove, 0) >= toMove.getMaxLevel()) return false;
        if (!given.keySet().stream().filter(Predicate.isEqual(toMove).negate()).allMatch(arg_0 -> ((Enchantment)toMove).isCompatibleWith(arg_0))) return false;
        return true;
    }

    public Optional<Enchantment> getEnchantment() {
        return Optional.ofNullable(this.selected);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack src = ItemStack.EMPTY;
        Slot slot = this.getSlot(index);
        if (slot.hasItem()) {
            ItemStack remain = slot.getItem();
            src = remain.copy();
            if (index < 2) {
                if (!this.moveItemStackTo(remain, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
            } else {
                ItemStack put = ItemHandlerHelper.copyStackWithSize((ItemStack)remain, (int)1);
                boolean changed = false;
                Slot toSlot = this.getSlot(0);
                if (toSlot.mayPlace(remain) && toSlot.getItem().isEmpty()) {
                    toSlot.set(put);
                    remain.shrink(1);
                    changed = true;
                }
                toSlot = this.getSlot(1);
                if (!changed && toSlot.mayPlace(remain) && toSlot.getItem().isEmpty()) {
                    toSlot.set(put);
                    remain.shrink(1);
                    changed = true;
                }
                if (!changed) {
                    return ItemStack.EMPTY;
                }
            }
            if (remain.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (remain.getCount() == src.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, remain);
        }
        return src;
    }

    public void moveEnchant(Enchantment enchantment) {
        ItemStack from = this.craftMatrix.getItem(0);
        ItemStack to = this.craftMatrix.getItem(1);
        ContainerMover.moveEnchantment(enchantment, from, to, this::updateEnchantmentList);
    }

    static void moveEnchantment(@Nullable Enchantment enchantment, ItemStack from, ItemStack to, Runnable after) {
        EnchantableItem item;
        Item item2 = to.getItem();
        ContainerMover.moveEnchantment(enchantment, from, to, item2 instanceof EnchantableItem ? (item = (EnchantableItem)item2) : null, after);
    }

    @VisibleForTesting
    static void moveEnchantment(@Nullable Enchantment enchantment, ItemStack from, ItemStack to, @Nullable Predicate<Enchantment> predicate, Runnable after) {
        if (enchantment == null || from.isEmpty() || to.isEmpty()) {
            return;
        }
        if (ContainerMover.canMoveEnchantment(predicate, EnchantmentHelper.getEnchantments((ItemStack)to), enchantment)) {
            ContainerMover.upLevel(enchantment, to);
            ContainerMover.downLevel(enchantment, from);
            after.run();
        }
    }

    @VisibleForTesting
    static void downLevel(Enchantment enchantment, ItemStack stack) {
        ListTag list = stack.getEnchantmentTags();
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag nbt = list.getCompound(i);
                if (ForgeRegistries.ENCHANTMENTS.getValue(EnchantmentHelper.getEnchantmentId((CompoundTag)nbt)) != enchantment) continue;
                int l = EnchantmentHelper.getEnchantmentLevel((CompoundTag)nbt);
                if (l == 1) {
                    list.remove(i);
                    break;
                }
                EnchantmentHelper.setEnchantmentLevel((CompoundTag)nbt, (int)(l - 1));
                break;
            }
            if (list.isEmpty()) {
                stack.removeTagKey("Enchantments");
            }
        }
    }

    @VisibleForTesting
    static void upLevel(Enchantment enchantment, ItemStack stack) {
        int level = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)enchantment, (ItemStack)stack);
        if (level == 0) {
            stack.enchant(enchantment, 1);
        } else {
            ListTag list = stack.getEnchantmentTags();
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag nbt = list.getCompound(i);
                if (ForgeRegistries.ENCHANTMENTS.getValue(EnchantmentHelper.getEnchantmentId((CompoundTag)nbt)) != enchantment) continue;
                EnchantmentHelper.setEnchantmentLevel((CompoundTag)nbt, (int)(level + 1));
                break;
            }
        }
    }
}

