/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.mover;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.yogpc.qp.machines.misc.IndexedButton;
import com.yogpc.qp.machines.mover.ContainerMover;
import com.yogpc.qp.machines.mover.MoverMessage;
import com.yogpc.qp.packet.PacketHandler;
import java.util.Optional;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoverScreen
extends AbstractContainerScreen<ContainerMover>
implements Button.OnPress {
    private static final ResourceLocation LOCATION = new ResourceLocation("quarryplus", "textures/gui/mover.png");
    private final BlockPos pos;
    private IndexedButton enchantmentMoveButton;

    public MoverScreen(ContainerMover containerMarker, Inventory inventory, Component component) {
        super((AbstractContainerMenu)containerMarker, inventory, component);
        this.pos = containerMarker.pos;
        this.imageWidth = 176;
        this.imageHeight = 186;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    public void init() {
        super.init();
        int width = 120;
        this.addRenderableWidget((GuiEventListener)new IndexedButton(0, this.getGuiLeft() + (this.imageWidth - width) / 2, this.getGuiTop() + 20, width, 20, (Component)new TranslatableComponent("FD.up"), this));
        this.enchantmentMoveButton = new IndexedButton(1, this.getGuiLeft() + (this.imageWidth - width) / 2, this.getGuiTop() + 40, width, 20, (Component)new TextComponent(""), this);
        this.addRenderableWidget((GuiEventListener)this.enchantmentMoveButton);
        this.addRenderableWidget((GuiEventListener)new IndexedButton(2, this.getGuiLeft() + (this.imageWidth - width) / 2, this.getGuiTop() + 60, width, 20, (Component)new TranslatableComponent("FD.down"), this));
    }

    public void render(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.renderBackground(matrices);
        super.render(matrices, mouseX, mouseY, delta);
        this.renderTooltip(matrices, mouseX, mouseY);
    }

    protected void renderBg(PoseStack matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LOCATION);
        this.blit(matrices, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void containerTick() {
        super.containerTick();
        Optional<Enchantment> enchantment = ((ContainerMover)this.getMenu()).getEnchantment();
        Component name = enchantment.map(Enchantment::getDescriptionId).map(TranslatableComponent::new).orElse((Component)new TextComponent(""));
        this.enchantmentMoveButton.setMessage(name);
    }

    public void onPress(Button button) {
        if (!button.active || ((ContainerMover)this.getMenu()).selected == null) {
            return;
        }
        if (button instanceof IndexedButton) {
            IndexedButton indexedButton = (IndexedButton)button;
            switch (indexedButton.id()) {
                case 1: {
                    this.moveEnchantment();
                    break;
                }
                case 0: {
                    this.selectPrevious();
                    break;
                }
                case 2: {
                    this.selectNext();
                }
            }
        }
    }

    private void selectNext() {
        int index = ((ContainerMover)this.getMenu()).movable.indexOf(((ContainerMover)this.getMenu()).selected);
        if (index >= 0) {
            ((ContainerMover)this.getMenu()).selected = index == ((ContainerMover)this.getMenu()).movable.size() - 1 ? ((ContainerMover)this.getMenu()).movable.get(0) : ((ContainerMover)this.getMenu()).movable.get(index + 1);
        }
    }

    private void selectPrevious() {
        int index = ((ContainerMover)this.getMenu()).movable.indexOf(((ContainerMover)this.getMenu()).selected);
        if (index >= 0) {
            ((ContainerMover)this.getMenu()).selected = index == 0 ? ((ContainerMover)this.getMenu()).movable.get(((ContainerMover)this.getMenu()).movable.size() - 1) : ((ContainerMover)this.getMenu()).movable.get(index - 1);
        }
    }

    private void moveEnchantment() {
        assert (((ContainerMover)this.getMenu()).selected != null);
        PacketHandler.sendToServer(new MoverMessage(this.pos, ((ContainerMover)this.getMenu()).containerId, ((ContainerMover)this.getMenu()).selected));
    }
}

