/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.mover;

import com.yogpc.qp.machines.EnchantableItem;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.common.TierSortingRegistry;

class SlotMover
extends Slot {
    public SlotMover(Container container, int index, int x, int y) {
        super(container, index, x, y);
    }

    public boolean mayPlace(ItemStack stack) {
        switch (this.getSlotIndex()) {
            case 0: {
                if (stack.getEnchantmentTags().isEmpty()) {
                    return false;
                }
                Item item = stack.getItem();
                if (item instanceof TieredItem) {
                    TieredItem tieredItem = (TieredItem)item;
                    return !TierSortingRegistry.getTiersLowerThan((Tier)Tiers.DIAMOND).contains(tieredItem.getTier());
                }
                item = stack.getItem();
                if (item instanceof ArmorItem) {
                    ArmorItem armorItem = (ArmorItem)item;
                    ArmorMaterial armorMaterial = armorItem.getMaterial();
                    if (armorMaterial instanceof ArmorMaterials) {
                        ArmorMaterials material = (ArmorMaterials)armorMaterial;
                        return material.ordinal() >= ArmorMaterials.DIAMOND.ordinal();
                    }
                    return false;
                }
                return stack.getItem() instanceof BowItem;
            }
            case 1: {
                return stack.getItem() instanceof EnchantableItem;
            }
        }
        return false;
    }

    public int getMaxStackSize() {
        return 1;
    }
}

