/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.placer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.yogpc.qp.machines.placer.PlacerContainer;
import com.yogpc.qp.machines.placer.PlacerTile;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlacerScreen
extends AbstractContainerScreen<PlacerContainer> {
    private static final ResourceLocation LOCATION = new ResourceLocation("quarryplus", "textures/gui/replacer.png");

    public PlacerScreen(PlacerContainer c, Inventory inventory, Component component) {
        super((AbstractContainerMenu)c, inventory, component);
    }

    protected ResourceLocation textureLocation() {
        return LOCATION;
    }

    public void render(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.renderBackground(matrices);
        super.render(matrices, mouseX, mouseY, delta);
        this.renderTooltip(matrices, mouseX, mouseY);
    }

    protected void renderBg(PoseStack matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.textureLocation());
        this.blit(matrices, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.imageWidth, this.imageHeight);
        int oneBox = 18;
        int x = ((PlacerContainer)this.getMenu()).startX - 1 + ((PlacerContainer)this.getMenu()).tile.getLastPlacedIndex() % 3 * oneBox;
        int y = 16 + ((PlacerContainer)this.getMenu()).tile.getLastPlacedIndex() / 3 * oneBox;
        this.blit(matrices, this.getGuiLeft() + x, this.getGuiTop() + y, 176, 0, oneBox, oneBox);
    }

    protected void renderLabels(PoseStack matrices, int mouseX, int mouseY) {
        super.renderLabels(matrices, mouseX, mouseY);
        this.renderModeLabel(matrices);
    }

    protected void renderModeLabel(PoseStack matrices) {
        PlacerTile.RedstoneMode mode = ((PlacerContainer)this.getMenu()).tile.redstoneMode;
        String pA = mode.isAlways() ? "Always" : "Pulse";
        int x = 116;
        this.font.draw(matrices, pA, (float)x, 6.0f, 0x404040);
        String rs = mode.isRsOn() ? "RS On" : (mode.isRsOff() ? "RS Off" : "");
        this.font.draw(matrices, rs, (float)x, 18.0f, 0x404040);
        String only = mode.canBreak() && !mode.canPlace() ? "Break Only" : (mode.canPlace() && !mode.canBreak() ? "Place Only" : "");
        this.font.draw(matrices, only, (float)x, 30.0f, 0x404040);
    }
}

