/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.placer;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.QuarryFakePlayer;
import com.yogpc.qp.machines.placer.PlacerBlock;
import com.yogpc.qp.machines.placer.PlacerContainer;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.TileMessage;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlacerTile
extends BlockEntity
implements Container,
CheckerLog,
MenuProvider {
    public static final String KEY_ITEM = "items";
    public static final String KEY_LAST_PLACED = "last_placed";
    public static final String KEY_RS_MODE = "redstone_mode";
    public static final Map<Direction, Vec3> DIRECTION_VEC3D_MAP;
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    private int lastPlacedIndex = 0;
    public RedstoneMode redstoneMode = RedstoneMode.PULSE;
    private final IItemHandler itemHandler = new InvWrapper((Container)this);
    private final LazyOptional<IItemHandler> itemHandlerOpt = LazyOptional.of(() -> this.itemHandler);
    private static final int PULSE_ID = 0;
    private static final int RS_IGNORE_ID = 1;
    private static final int RS_ON_ID = 2;
    private static final int RS_OFF_ID = 3;

    public PlacerTile(BlockPos pos, BlockState state) {
        super(Holder.PLACER_TYPE, pos, state);
    }

    protected PlacerTile(BlockEntityType<?> entityType, BlockPos pos, BlockState state) {
        super(entityType, pos, state);
    }

    public void tick() {
        boolean placed;
        if (this.level != null && !this.level.isClientSide && this.redstoneMode.isAlways() && this.redstoneMode.shouldWork(this::isPowered) && !(placed = this.placeBlock())) {
            this.breakBlock();
        }
    }

    protected BlockPos getTargetPos() {
        return this.getBlockPos().relative(this.getMachineFacing());
    }

    protected Direction getMachineFacing() {
        return (Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING);
    }

    protected boolean isPowered() {
        return PlacerBlock.isPoweredToWork(this.level, this.getBlockPos(), this.getMachineFacing());
    }

    void breakBlock() {
        if (this.level == null || !this.redstoneMode.canBreak()) {
            return;
        }
        BlockPos pos = this.getTargetPos();
        BlockState state = this.level.getBlockState(pos);
        if (state.getDestroySpeed((BlockGetter)this.level, pos) < 0.0f) {
            return;
        }
        FakePlayer fake = QuarryFakePlayer.get((ServerLevel)this.level);
        fake.setItemInHand(InteractionHand.MAIN_HAND, PlacerTile.getSilkPickaxe());
        List drops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)this.level), (BlockPos)pos, (BlockEntity)this.level.getBlockEntity(pos), (Entity)fake, (ItemStack)fake.getMainHandItem());
        this.level.removeBlock(pos, false);
        drops.stream().map(s -> ItemHandlerHelper.insertItem((IItemHandler)this.itemHandler, (ItemStack)s, (boolean)false)).filter(Predicate.not(ItemStack::isEmpty)).forEach(s -> Block.popResource((Level)this.level, (BlockPos)this.getBlockPos(), (ItemStack)s));
    }

    boolean placeBlock() {
        if (this.isEmpty() || !this.redstoneMode.canPlace()) {
            return false;
        }
        Direction facing = this.getMachineFacing();
        BlockPos pos = this.getTargetPos();
        Vec3 hitPos = DIRECTION_VEC3D_MAP.get(facing.getOpposite()).add((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        BlockHitResult rayTrace = new BlockHitResult(hitPos, facing.getOpposite(), pos, false);
        FakePlayer fake = QuarryFakePlayer.get((ServerLevel)this.level);
        AtomicBoolean result = new AtomicBoolean(false);
        PlacerTile.findEntry(this.inventory, arg_0 -> PlacerTile.lambda$placeBlock$2((Player)fake, rayTrace, arg_0), this.lastPlacedIndex).ifPresent(i -> {
            this.lastPlacedIndex = !this.getItem(i).isEmpty() ? i : PlacerTile.findEntry(this.inventory, s -> !s.isEmpty() && s.getItem() instanceof BlockItem, i).orElse(0);
            this.setChanged();
            this.sendPacket();
            result.set(true);
        });
        fake.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        return result.get();
    }

    public static <T> OptionalInt findEntry(List<T> check, Predicate<T> filter, int startIndex) {
        int listSize = check.size();
        if (startIndex >= listSize) {
            return OptionalInt.empty();
        }
        return PlacerTile.findEntryInternal(check, filter, startIndex, startIndex, listSize);
    }

    private static <T> OptionalInt findEntryInternal(List<T> check, Predicate<T> filter, int startIndex, int index, int listSize) {
        T value = check.get(index);
        if (filter.test(value)) {
            return OptionalInt.of(index);
        }
        if (index == startIndex - 1 || startIndex == 0 && index == listSize - 1) {
            return OptionalInt.empty();
        }
        int next = index + 1 == listSize ? 0 : index + 1;
        return PlacerTile.findEntryInternal(check, filter, startIndex, next, listSize);
    }

    static boolean tryPlaceItem(ItemStack stack, Player fake, BlockHitResult rayTrace) {
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            fake.setItemInHand(InteractionHand.MAIN_HAND, stack);
            BlockPlaceContext context = new BlockPlaceContext(new UseOnContext(fake, InteractionHand.MAIN_HAND, rayTrace));
            return blockItem.place(context).consumesAction();
        }
        return false;
    }

    public int getLastPlacedIndex() {
        return this.lastPlacedIndex;
    }

    void sendPacket() {
        if (this.level != null && !this.level.isClientSide) {
            PacketHandler.sendToClient(new TileMessage(this), this.level);
        }
    }

    private static ItemStack getSilkPickaxe() {
        ItemStack stack = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
        stack.enchant(Enchantments.SILK_TOUCH, 1);
        return stack;
    }

    protected void saveAdditional(CompoundTag compound) {
        compound.put(KEY_ITEM, (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.inventory));
        compound.putInt(KEY_LAST_PLACED, this.lastPlacedIndex);
        compound.putString(KEY_RS_MODE, this.redstoneMode.name());
        super.saveAdditional(compound);
    }

    public void load(CompoundTag compound) {
        super.load(compound);
        ContainerHelper.loadAllItems((CompoundTag)compound.getCompound(KEY_ITEM), this.inventory);
        this.lastPlacedIndex = compound.getInt(KEY_LAST_PLACED);
        try {
            this.redstoneMode = RedstoneMode.valueOf(compound.getString(KEY_RS_MODE));
        }
        catch (IllegalArgumentException e) {
            QuarryPlus.LOGGER.error("Illegal name(%s) was passed to placer mode.".formatted(compound.getString(KEY_RS_MODE)), (Throwable)e);
            this.redstoneMode = RedstoneMode.PULSE;
        }
    }

    public CompoundTag getUpdateTag() {
        return this.serializeNBT();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.itemHandlerOpt);
        }
        return super.getCapability(cap, side);
    }

    public Component getDisplayName() {
        return this.getBlockState().getBlock().getName();
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        return Stream.of("RS Mode: " + this.redstoneMode.toString(), "Last Placed: " + this.getLastPlacedIndex(), "Target: " + String.valueOf(this.getTargetPos()), "Inv: " + this.inventory.stream().filter(Predicate.not(ItemStack::isEmpty)).count()).map(TextComponent::new).collect(Collectors.toList());
    }

    public int getContainerSize() {
        return 9;
    }

    public boolean isEmpty() {
        return this.inventory.stream().allMatch(ItemStack::isEmpty);
    }

    public ItemStack getItem(int index) {
        if (index >= 0 && index < this.getContainerSize()) {
            return (ItemStack)this.inventory.get(index);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem(this.inventory, (int)index, (int)count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.inventory, (int)index);
    }

    public void setItem(int index, ItemStack stack) {
        if (index >= 0 && index < this.getContainerSize()) {
            this.inventory.set(index, (Object)stack);
        }
    }

    public boolean stillValid(Player player) {
        return this.level != null && this.getBlockPos().distToCenterSqr((Position)player.position()) < 64.0;
    }

    public void clearContent() {
        this.inventory.clear();
    }

    public int getMaxStackSize() {
        return 64;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return true;
    }

    public PlacerContainer createMenu(int id, Inventory p, Player player) {
        return new PlacerContainer(id, player, this.getBlockPos(), this.getClass());
    }

    public void cycleRedstoneMode() {
        this.redstoneMode = RedstoneMode.cycle(this.redstoneMode);
        if (this.level != null && !this.level.isClientSide) {
            this.sendPacket();
        }
    }

    private static /* synthetic */ boolean lambda$placeBlock$2(Player fake, BlockHitResult rayTrace, ItemStack i) {
        return PlacerTile.tryPlaceItem(i, fake, rayTrace);
    }

    static {
        EnumMap<Direction, Vec3> map = new EnumMap<Direction, Vec3>(Direction.class);
        map.put(Direction.DOWN, new Vec3(0.5, 0.0, 0.5));
        map.put(Direction.UP, new Vec3(0.5, 1.0, 0.5));
        map.put(Direction.NORTH, new Vec3(0.5, 0.5, 0.0));
        map.put(Direction.SOUTH, new Vec3(0.5, 0.5, 1.0));
        map.put(Direction.EAST, new Vec3(1.0, 0.5, 0.5));
        map.put(Direction.WEST, new Vec3(0.0, 0.5, 0.5));
        DIRECTION_VEC3D_MAP = Collections.unmodifiableMap(map);
    }

    public static enum RedstoneMode {
        PULSE(0, true, true),
        PULSE_PLACE_ONLY(0, true, false),
        PULSE_BREAK_ONLY(0, false, true);

        private final int modeID;
        private final boolean placeEnabled;
        private final boolean breakEnabled;

        private RedstoneMode(int modeID, boolean placeEnabled, boolean breakEnabled) {
            this.modeID = modeID;
            this.placeEnabled = placeEnabled;
            this.breakEnabled = breakEnabled;
        }

        public String toString() {
            return this.name().replace('_', ' ');
        }

        public boolean isAlways() {
            return this.modeID == 1 || this.modeID == 2 || this.modeID == 3;
        }

        public boolean isPulse() {
            return this.modeID == 0;
        }

        public boolean canPlace() {
            return this.placeEnabled;
        }

        public boolean canBreak() {
            return this.breakEnabled;
        }

        public boolean isRsOn() {
            return this.modeID == 2;
        }

        public boolean isRsOff() {
            return this.modeID == 3;
        }

        public boolean shouldWork(BooleanSupplier powered) {
            if (this.isRsOn()) {
                return powered.getAsBoolean();
            }
            if (this.isRsOff()) {
                return !powered.getAsBoolean();
            }
            return true;
        }

        public static RedstoneMode cycle(RedstoneMode now) {
            RedstoneMode[] modes = RedstoneMode.values();
            for (int i = 0; i < modes.length; ++i) {
                RedstoneMode mode = modes[i];
                if (mode != now) continue;
                if (i + 1 == modes.length) {
                    return modes[0];
                }
                return modes[i + 1];
            }
            return modes[0];
        }
    }
}

