/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.placer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yogpc.qp.machines.misc.IndexedButton;
import com.yogpc.qp.machines.placer.PlacerContainer;
import com.yogpc.qp.machines.placer.PlacerScreen;
import com.yogpc.qp.machines.placer.PlacerTile;
import com.yogpc.qp.machines.placer.RemotePlacerMessage;
import com.yogpc.qp.machines.placer.RemotePlacerTile;
import com.yogpc.qp.packet.PacketHandler;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class RemotePlacerScreen
extends PlacerScreen
implements Button.OnPress {
    private static final ResourceLocation LOCATION = new ResourceLocation("quarryplus", "textures/gui/remote_replacer.png");

    public RemotePlacerScreen(PlacerContainer c, Inventory inventory, Component component) {
        super(c, inventory, component);
    }

    @Override
    protected ResourceLocation textureLocation() {
        return LOCATION;
    }

    protected void init() {
        super.init();
        AtomicInteger counter = new AtomicInteger(0);
        for (int i = 0; i < 3; ++i) {
            int yPos = this.getGuiTop() + 21 + i * 18;
            this.addRenderableWidget((GuiEventListener)new IndexedButton(counter.getAndIncrement(), this.getGuiLeft() + 97, yPos, 18, 9, (Component)new TextComponent("-"), this));
            this.addRenderableWidget((GuiEventListener)new IndexedButton(counter.getAndIncrement(), this.getGuiLeft() + 151, yPos, 18, 9, (Component)new TextComponent("+"), this));
        }
    }

    @Override
    protected void renderLabels(PoseStack matrices, int mouseX, int mouseY) {
        super.renderLabels(matrices, mouseX, mouseY);
        BlockPos targetPos = ((PlacerContainer)this.getMenu()).tile.getTargetPos();
        int color = targetPos.equals((Object)((PlacerContainer)this.getMenu()).tile.getBlockPos()) ? 0xFF4040 : 0x404040;
        int x = 116;
        this.font.draw(matrices, "X: " + targetPos.getX(), (float)x, 22.0f, color);
        this.font.draw(matrices, "Y: " + targetPos.getY(), (float)x, 40.0f, color);
        this.font.draw(matrices, "Z: " + targetPos.getZ(), (float)x, 58.0f, color);
    }

    @Override
    protected void renderModeLabel(PoseStack matrices) {
        String pA;
        PlacerTile.RedstoneMode mode = ((PlacerContainer)this.getMenu()).tile.redstoneMode;
        String string = pA = mode.isAlways() ? "Always" : "Pulse";
        String rs = mode.isRsOn() ? "RS On" : (mode.isRsOff() ? "RS Off" : "");
        String only = mode.canBreak() && !mode.canPlace() ? "Break" : (mode.canPlace() && !mode.canBreak() ? "Place" : "");
        this.font.draw(matrices, pA, 90.0f, 6.0f, 0x404040);
        this.font.draw(matrices, only, 130.0f, 6.0f, 0x404040);
        this.font.draw(matrices, rs, 100.0f, (float)this.inventoryLabelY, 0x404040);
    }

    public void onPress(Button pButton) {
        if (pButton instanceof IndexedButton) {
            IndexedButton indexedButton = (IndexedButton)pButton;
            PlacerTile placerTile = ((PlacerContainer)this.getMenu()).tile;
            if (placerTile instanceof RemotePlacerTile) {
                BlockPos newPos;
                RemotePlacerTile remotePlacerTile = (RemotePlacerTile)placerTile;
                int amount = (switch (indexedButton.getIndex() % 2) {
                    case 0 -> -1;
                    case 1 -> 1;
                    default -> throw new AssertionError((Object)"X % 2 must in 0-1.");
                }) * (Screen.hasShiftDown() ? 16 : (Screen.hasControlDown() ? 4 : 1));
                Direction.Axis axis = switch (indexedButton.getIndex() / 2) {
                    case 0 -> Direction.Axis.X;
                    case 1 -> Direction.Axis.Y;
                    case 2 -> Direction.Axis.Z;
                    default -> throw new IllegalArgumentException("Bad index " + indexedButton.getIndex());
                };
                remotePlacerTile.targetPos = newPos = remotePlacerTile.getTargetPos().relative(axis, amount);
                PacketHandler.sendToServer(new RemotePlacerMessage(remotePlacerTile, newPos));
            }
        }
    }
}

