/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.placer;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.placer.PlacerBlock;
import com.yogpc.qp.machines.placer.PlacerTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;

public final class RemotePlacerTile
extends PlacerTile {
    public static final String KEY_TARGET = "targetPos";
    BlockPos targetPos;

    public RemotePlacerTile(BlockPos pos, BlockState state) {
        super(Holder.REMOTE_PLACER_TYPE, pos, state);
        this.targetPos = pos.above();
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        super.saveAdditional(compound);
        compound.putLong(KEY_TARGET, this.targetPos.asLong());
    }

    @Override
    public void load(CompoundTag compound) {
        super.load(compound);
        if (compound.contains(KEY_TARGET, 4)) {
            this.targetPos = BlockPos.of((long)compound.getLong(KEY_TARGET));
        }
    }

    @Override
    protected BlockPos getTargetPos() {
        return this.targetPos;
    }

    @Override
    protected Direction getMachineFacing() {
        return Direction.UP;
    }

    @Override
    protected boolean isPowered() {
        return PlacerBlock.isPoweredToWork(this.level, this.getBlockPos(), null);
    }
}

