/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.quarry.Target;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DigTarget
extends Target {
    final Area area;
    final int y;
    @Nullable
    private BlockPos.MutableBlockPos currentTarget;

    DigTarget(Area area, int y) {
        this.area = area;
        this.y = y;
        int x = y % 2 == 0 ? area.minX() + 1 : area.maxX() - 1;
        this.currentTarget = new BlockPos.MutableBlockPos(x, y, DigTarget.initZ(x, this.y, area.minZ() + 1, area.maxZ() - 1));
    }

    @Override
    @Nullable
    public BlockPos get(boolean goNext) {
        if (this.currentTarget == null) {
            return null;
        }
        BlockPos pre = this.currentTarget.immutable();
        if (goNext) {
            int nextZ;
            int n = nextZ = pre.getX() % 2 == 0 ^ this.y % 2 == 0 ? pre.getZ() + 1 : pre.getZ() - 1;
            if (this.area.minZ() < nextZ && nextZ < this.area.maxZ()) {
                this.currentTarget.set(pre.getX(), pre.getY(), nextZ);
            } else {
                int nextX;
                int n2 = nextX = this.y % 2 == 0 ? pre.getX() + 1 : pre.getX() - 1;
                if (this.area.minX() < nextX && nextX < this.area.maxX()) {
                    this.currentTarget.set(nextX, pre.getY(), DigTarget.initZ(nextX, this.y, this.area.minZ() + 1, this.area.maxZ() - 1));
                } else {
                    this.currentTarget = null;
                    return null;
                }
            }
        }
        return pre;
    }

    @Override
    @NotNull
    public Stream<BlockPos> allPoses() {
        return BlockPos.betweenClosedStream((int)this.area.minX(), (int)this.y, (int)this.area.minZ(), (int)this.area.maxX(), (int)this.y, (int)this.area.maxZ());
    }

    @Override
    @NotNull
    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.put("area", (Tag)this.area.toNBT());
        tag.putInt("y", this.y);
        if (this.currentTarget != null) {
            tag.putLong("currentTarget", this.currentTarget.asLong());
        }
        return tag;
    }

    @Override
    public double progress() {
        if (this.currentTarget == null) {
            return 1.0;
        }
        double xUnit = 1.0 / (double)(this.area.maxX() - this.area.minX() - 1);
        double xProgress = this.y % 2 == 0 ? xUnit * (double)(this.currentTarget.getX() - this.area.minX() - 1) : xUnit * (double)(this.area.maxX() - this.currentTarget.getX() - 1);
        return xProgress;
    }

    static DigTarget from(CompoundTag tag) {
        DigTarget target = new DigTarget(Area.fromNBT(tag.getCompound("area")).orElseThrow(), tag.getInt("y"));
        if (tag.contains("currentTarget")) {
            assert (target.currentTarget != null);
            target.currentTarget.set(tag.getLong("currentTarget"));
        } else {
            target.currentTarget = null;
        }
        return target;
    }

    static int initZ(int x, int y, int minZ, int maxZ) {
        return x % 2 == 0 ^ y % 2 == 0 ? minZ : maxZ;
    }

    public String toString() {
        return "DigTarget{area=" + String.valueOf(this.area) + ", y=" + this.y + ", currentTarget=" + String.valueOf(this.currentTarget) + "}";
    }
}

