/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.filler.FillerAction;
import com.yogpc.qp.machines.filler.FillerTargetPosIterator;
import com.yogpc.qp.machines.filler.SkipIterator;
import com.yogpc.qp.machines.quarry.Target;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FillerTarget
extends Target {
    private final Area area;
    final FillerAction fillerAction;

    FillerTarget(Area area) {
        this.area = area;
        this.fillerAction = new FillerAction();
        this.fillerAction.setIterator(new SkipIterator(area, FillerTargetPosIterator::box));
    }

    public static FillerTarget from(CompoundTag tag) {
        Area area = Area.fromNBT(tag.getCompound("area")).orElseThrow();
        FillerTarget target = new FillerTarget(area);
        target.fillerAction.fromNbt(tag.getCompound("fillerAction"));
        return target;
    }

    @Override
    @Deprecated
    @Nullable
    public BlockPos get(boolean goNext) {
        return null;
    }

    @Override
    @NotNull
    public Stream<BlockPos> allPoses() {
        FillerTargetPosIterator itr = FillerTargetPosIterator.box(this.area);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(itr, 0), false);
    }

    @Override
    @NotNull
    protected CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.put("area", (Tag)this.area.toNBT());
        tag.put("fillerAction", (Tag)this.fillerAction.toNbt());
        return tag;
    }

    @Override
    public double progress() {
        return 0.0;
    }
}

