/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.integration.ftbchunks.FTBChunksProtectionCheck;
import com.yogpc.qp.integration.wrench.WrenchItems;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.Direction8;
import com.yogpc.qp.machines.EnchantedLootFunction;
import com.yogpc.qp.machines.MachineStorage;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.QuarryMarker;
import com.yogpc.qp.machines.module.ContainerQuarryModule;
import com.yogpc.qp.machines.module.EnergyModuleItem;
import com.yogpc.qp.machines.module.ModuleLootFunction;
import com.yogpc.qp.machines.quarry.FrameBlock;
import com.yogpc.qp.machines.quarry.QuarryItem;
import com.yogpc.qp.machines.quarry.QuarryLootFunction;
import com.yogpc.qp.machines.quarry.QuarryState;
import com.yogpc.qp.machines.quarry.TileQuarry;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.TileMessage;
import com.yogpc.qp.utils.CombinedBlockEntityTicker;
import com.yogpc.qp.utils.MapMulti;
import com.yogpc.qp.utils.QuarryChunkLoadUtil;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class QuarryBlock
extends QPBlock
implements EntityBlock {
    public static final String NAME = "quarry";

    public QuarryBlock() {
        super(BlockBehaviour.Properties.of((Material)Material.METAL).strength(1.5f, 10.0f).sound(SoundType.STONE), NAME, QuarryItem::new);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WORKING, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WORKING, BlockStateProperties.FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction facing = ctx.getPlayer() == null ? Direction.NORTH : ctx.getPlayer().getDirection().getOpposite();
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)facing);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(level, pos, state, entity, stack);
        if (!level.isClientSide) {
            Direction facing = entity == null ? Direction.NORTH : entity.getDirection().getOpposite();
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof TileQuarry) {
                TileQuarry quarry = (TileQuarry)blockEntity;
                quarry.setEnchantments(EnchantmentHelper.getEnchantments((ItemStack)stack));
                quarry.setTileDataFromItem(BlockItem.getBlockEntityData((ItemStack)stack));
                Area area = QuarryBlock.findArea(level, pos, facing.getOpposite(), quarry.storage::addItem);
                if (FTBChunksProtectionCheck.isAreaProtected(area, (ResourceKey<Level>)level.dimension())) {
                    if (entity instanceof Player) {
                        player = (Player)entity;
                        player.displayClientMessage((Component)new TranslatableComponent("quarryplus.chat.warn_protected_area"), false);
                    }
                } else if (area.maxX() - area.minX() > 1 && area.maxZ() - area.minZ() > 1) {
                    quarry.setState(QuarryState.WAITING, (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)facing));
                    quarry.setArea(area);
                } else if (entity instanceof Player) {
                    player = (Player)entity;
                    player.displayClientMessage((Component)new TranslatableComponent("quarryplus.chat.warn_area"), false);
                }
                quarry.updateModules();
                boolean preForced = QuarryChunkLoadUtil.makeChunkLoaded(level, pos, quarry.enabled);
                quarry.setChunkPreLoaded(preForced);
                PacketHandler.sendToClient(new TileMessage(quarry), level);
            }
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock()) && ((Boolean)QuarryPlus.config.common.removeFrameAfterQuarryIsRemoved.get()).booleanValue()) {
            for (Direction8 dir : Direction8.DIRECTIONS) {
                BlockPos offset = pos.offset(dir.vec());
                BlockState maybeFrame = level.getBlockState(offset);
                if (!maybeFrame.is((Block)Holder.BLOCK_FRAME) || ((Boolean)maybeFrame.getValue((Property)FrameBlock.DAMMING)).booleanValue()) continue;
                level.removeBlock(offset, false);
            }
        }
        super.onRemove(state, level, pos, newState, moved);
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!QuarryPlus.config.enableMap.enabled(NAME)) {
            if (!world.isClientSide) {
                player.displayClientMessage((Component)new TranslatableComponent("quarryplus.chat.disable_message", new Object[]{this.getName()}), true);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        ItemStack stack = player.getItemInHand(hand);
        if (WrenchItems.isWrenchItem(stack)) {
            BlockEntity blockEntity;
            if (!world.isClientSide && (blockEntity = world.getBlockEntity(pos)) instanceof TileQuarry) {
                TileQuarry quarry = (TileQuarry)blockEntity;
                quarry.setState(QuarryState.WAITING, state);
                quarry.target = null;
            }
            return InteractionResult.SUCCESS;
        }
        if (!player.isShiftKeyDown()) {
            BlockEntity blockEntity;
            if (!world.isClientSide && (blockEntity = world.getBlockEntity(pos)) instanceof TileQuarry) {
                TileQuarry quarry = (TileQuarry)blockEntity;
                ContainerQuarryModule.InteractionObject.openGUI(quarry, (ServerPlayer)player, (Component)this.getName());
            }
            return InteractionResult.SUCCESS;
        }
        return super.use(state, world, pos, player, hand, hit);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return Holder.QUARRY_TYPE.create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : QuarryBlock.checkType(blockEntityType, Holder.QUARRY_TYPE, new CombinedBlockEntityTicker(PowerTile.getGenerator(), EnergyModuleItem.energyModuleTicker(), TileQuarry::tick, PowerTile.logTicker(), MachineStorage.passItems(), MachineStorage.passFluid()));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, world, pos, player);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof TileQuarry) {
            TileQuarry quarry = (TileQuarry)blockEntity;
            QuarryLootFunction.process(stack, quarry);
            EnchantedLootFunction.process(stack, quarry);
            ModuleLootFunction.process(stack, quarry);
        }
        return stack;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        super.neighborChanged(state, world, pos, block, fromPos, notify);
        if (!world.isClientSide) {
            world.getBlockEntity(pos, Holder.QUARRY_TYPE).ifPresent(TileQuarry::updateModules);
        }
    }

    static Area findArea(Level world, BlockPos pos, Direction quarryBehind, Consumer<ItemStack> itemCollector) {
        return Stream.of(quarryBehind, quarryBehind.getCounterClockWise(), quarryBehind.getClockWise()).map(arg_0 -> ((BlockPos)pos).relative(arg_0)).map(arg_0 -> ((Level)world).getBlockEntity(arg_0)).mapMulti(MapMulti.cast(QuarryMarker.class)).flatMap(m -> m.getArea().stream().peek(a -> m.removeAndGetItems().forEach(itemCollector))).findFirst().map(a -> a.assureY(4)).orElse(new Area((Vec3i)pos.relative(quarryBehind).relative(quarryBehind.getCounterClockWise(), 5), (Vec3i)pos.relative(quarryBehind, 11).relative(quarryBehind.getClockWise(), 5).relative(Direction.UP, 4), quarryBehind));
    }
}

