/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.quarry.QuarryLootFunctionSerializer;
import com.yogpc.qp.machines.quarry.TileQuarry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class QuarryLootFunction
extends LootItemConditionalFunction {
    public static final LootItemConditionalFunction.Serializer<QuarryLootFunction> SERIALIZER = new QuarryLootFunctionSerializer();
    public static final String NAME = "drop_function_quarry";

    protected QuarryLootFunction(LootItemCondition[] conditions) {
        super(conditions);
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        BlockEntity blockEntity = (BlockEntity)context.getParam(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof TileQuarry) {
            TileQuarry quarry = (TileQuarry)blockEntity;
            QuarryLootFunction.process(stack, quarry);
        }
        return stack;
    }

    public LootItemFunctionType getType() {
        return Holder.QUARRY_LOOT_TYPE;
    }

    static void process(ItemStack stack, TileQuarry quarry) {
        CompoundTag tileDataForItem = quarry.getTileDataForItem();
        if (!tileDataForItem.isEmpty()) {
            BlockItem.setBlockEntityData((ItemStack)stack, (BlockEntityType)quarry.getType(), (CompoundTag)tileDataForItem);
        }
    }

    public static LootItemConditionalFunction.Builder<?> builder() {
        return LootItemConditionalFunction.simpleBuilder(QuarryLootFunction::new);
    }
}

