/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.BreakResult;
import com.yogpc.qp.machines.PowerManager;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.filler.FillerAction;
import com.yogpc.qp.machines.quarry.FillerTarget;
import com.yogpc.qp.machines.quarry.StateConditions;
import com.yogpc.qp.machines.quarry.Target;
import com.yogpc.qp.machines.quarry.TileQuarry;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum QuarryState implements BlockEntityTicker<TileQuarry>
{
    FINISHED(false){

        @Override
        public void tick(Level world, BlockPos quarryPos, BlockState state, TileQuarry quarry) {
        }
    }
    ,
    WAITING(false){

        @Override
        public void tick(Level world, BlockPos quarryPos, BlockState state, TileQuarry quarry) {
            if (quarry.getArea() != null && quarry.getEnergy() > quarry.getMaxEnergy() / 200L) {
                quarry.setState(BREAK_INSIDE_FRAME, state);
            }
        }
    }
    ,
    BREAK_INSIDE_FRAME(true){

        @Override
        public void tick(Level world, BlockPos quarryPos, BlockState state, TileQuarry quarry) {
            BlockPos targetPos;
            if (world.getGameTime() % (long)3.headInterval(quarry) != 0L) {
                return;
            }
            Objects.requireNonNull(quarry.getArea());
            if (quarry.target == null) {
                quarry.target = Target.newFrameInside(quarry.getArea(), quarry.getArea().minY(), quarry.getArea().maxY());
                LOGGER.debug(MARKER, "{}({}) Target changed to {} in {}.", (Object)quarry.getClass().getSimpleName(), (Object)quarryPos, (Object)quarry.target, (Object)this.name());
            }
            if ((targetPos = QuarryState.dropUntilPos(quarry.target, StateConditions.skipNoBreak(quarry))) == null) {
                quarry.target = null;
                quarry.setState(MAKE_FRAME, state);
                return;
            }
            if (TileQuarry.isFullFluidBlock(quarry.getTargetWorld().getBlockState(targetPos))) {
                if (quarry.hasPumpModule()) {
                    quarry.setState(REMOVE_FLUID, state);
                } else {
                    quarry.target.get(true);
                }
            } else if (quarry.breakBlock(targetPos).isSuccess()) {
                quarry.target.get(true);
            }
        }
    }
    ,
    MAKE_FRAME(true){

        @Override
        public void tick(Level world, BlockPos quarryPos, BlockState state, TileQuarry quarry) {
            BlockPos targetPos;
            Objects.requireNonNull(quarry.getArea());
            if (quarry.target == null) {
                quarry.target = Target.newFrameTarget(quarry.getArea());
                this.logTargetChange(quarryPos, quarry);
            }
            if ((targetPos = QuarryState.dropUntilPos(quarry.target, StateConditions.skipFramePlace(quarry))) == null) {
                quarry.setState(MOVE_HEAD, state);
            } else {
                BreakResult breakResult = quarry.breakBlock(targetPos);
                if (breakResult.isSuccess() && quarry.useEnergy(PowerManager.getMakeFrameEnergy(quarry), PowerTile.Reason.MAKE_FRAME, false)) {
                    quarry.getTargetWorld().setBlockAndUpdate(targetPos, Holder.BLOCK_FRAME.defaultBlockState());
                }
            }
        }
    }
    ,
    MOVE_HEAD(true){

        @Override
        public void tick(Level world, BlockPos quarryPos, BlockState state, TileQuarry quarry) {
            BlockPos blockTarget;
            Objects.requireNonNull(quarry.getArea());
            if (quarry.target == null) {
                quarry.target = Target.newDigTarget(quarry.getArea(), quarry.getArea().minY());
                this.logTargetChange(quarryPos, quarry);
            }
            if ((blockTarget = QuarryState.dropUntilPos(quarry.target, StateConditions.skipNoBreak(quarry))) == null) {
                List<BlockPos> fluidPoses = quarry.target.allPoses().filter(p -> TileQuarry.isFullFluidBlock(quarry.getTargetWorld().getBlockState(p))).map(BlockPos::immutable).toList();
                if (!quarry.hasPumpModule() || fluidPoses.isEmpty()) {
                    quarry.target = Target.nextY(quarry.target, quarry.getArea(), quarry.digMinY);
                    this.logTargetChange(quarryPos, quarry);
                    if (quarry.target != null) {
                        this.tick(world, quarryPos, state, quarry);
                    } else if (quarry.hasFillerModule()) {
                        quarry.setState(FILLER, state);
                    } else {
                        quarry.setState(FINISHED, state);
                    }
                } else {
                    quarry.target = Target.poses(fluidPoses);
                    quarry.setState(REMOVE_FLUID, state);
                }
            } else {
                Vec3 difference = new Vec3((double)blockTarget.getX() - quarry.headX, (double)blockTarget.getY() - quarry.headY, (double)blockTarget.getZ() - quarry.headZ);
                double distance = difference.length();
                if (distance > 1.0E-4) {
                    double moveDistance = Math.min(distance, quarry.headSpeed());
                    long required = PowerManager.getMoveEnergy(moveDistance, quarry);
                    if (!quarry.useEnergy(required, PowerTile.Reason.MOVE_HEAD, false)) {
                        return;
                    }
                    Vec3 normalized = difference.normalize();
                    quarry.headX += normalized.x() * moveDistance;
                    quarry.headY += normalized.y() * moveDistance;
                    quarry.headZ += normalized.z() * moveDistance;
                    quarry.sync();
                }
                if (blockTarget.distToLowCornerSqr(quarry.headX, quarry.headY, quarry.headZ) <= 1.0E-8) {
                    BREAK_BLOCK.tick(world, quarryPos, state, quarry);
                }
            }
        }
    }
    ,
    BREAK_BLOCK(true){

        @Override
        public void tick(Level world, BlockPos quarryPos, BlockState state, TileQuarry quarry) {
            Objects.requireNonNull(quarry.getArea());
            if (quarry.target == null) {
                quarry.target = Target.newDigTarget(quarry.getArea(), quarry.getArea().minY());
                this.logTargetChange(quarryPos, quarry);
            }
            BlockPos targetPos = Objects.requireNonNull(quarry.target.get(false));
            if (TileQuarry.isFullFluidBlock(quarry.getTargetWorld().getBlockState(targetPos))) {
                if (quarry.hasPumpModule()) {
                    quarry.setState(REMOVE_FLUID, state);
                } else {
                    quarry.target.get(true);
                }
            } else if (quarry.breakBlock(targetPos).isSuccess()) {
                quarry.target.get(true);
                quarry.setState(MOVE_HEAD, state);
            } else {
                quarry.setState(BREAK_BLOCK, state);
            }
        }
    }
    ,
    REMOVE_FLUID(true){

        @Override
        public void tick(Level world, BlockPos quarryPos, BlockState state, TileQuarry quarry) {
            Objects.requireNonNull(quarry.getArea());
            if (quarry.target == null) {
                quarry.target = Target.newDigTarget(quarry.getArea(), quarry.getArea().minY());
                this.logTargetChange(quarryPos, quarry);
            }
            BlockPos original = Objects.requireNonNull(quarry.target.get(false));
            ServerLevel targetWorld = quarry.getTargetWorld();
            Set<BlockPos> fluidPoses = QuarryState.countFluid((Level)targetWorld, original, quarry.getArea());
            if (quarry.useEnergy(PowerManager.getBreakBlockFluidEnergy(quarry) * (long)fluidPoses.size(), PowerTile.Reason.REMOVE_FLUID, true)) {
                for (BlockPos fluidPos : fluidPoses) {
                    BlockState blockState = targetWorld.getBlockState(fluidPos);
                    if (blockState.getBlock() instanceof LiquidBlock) {
                        fluidState = targetWorld.getFluidState(fluidPos);
                        if (!fluidState.isEmpty() && fluidState.isSource()) {
                            quarry.storage.addFluid(fluidState.getType(), 1000L);
                        }
                        targetWorld.setBlock(fluidPos, Blocks.AIR.defaultBlockState(), 3);
                    } else {
                        fluidState = blockState.getBlock();
                        if (fluidState instanceof BucketPickup) {
                            BucketPickup drain = (BucketPickup)fluidState;
                            ItemStack bucket = drain.pickupBlock((LevelAccessor)targetWorld, fluidPos, blockState);
                            quarry.storage.addFluid(bucket);
                        } else {
                            targetWorld.setBlock(fluidPos, Blocks.AIR.defaultBlockState(), 3);
                        }
                    }
                    TileQuarry.removeEdgeFluid(fluidPos, targetWorld, quarry);
                }
                quarry.setState(BREAK_BLOCK, state);
            }
        }
    }
    ,
    FILLER(true){

        @Override
        public void tick(Level world, BlockPos quarryPos, BlockState state, TileQuarry quarry) {
            Objects.requireNonNull(quarry.getArea());
            if (!(quarry.target instanceof FillerTarget)) {
                Area area = quarry.getArea();
                quarry.target = Target.newFillerTarget(new Area(area.minX() + 1, quarry.digMinY + 1, area.minZ() + 1, area.maxX() - 1, area.minY() - 1, area.maxZ() - 1, area.direction()));
                this.logTargetChange(quarryPos, quarry);
            }
            FillerAction action = ((FillerTarget)quarry.target).fillerAction;
            long energy = PowerManager.getFillerEnergy(quarry) * 10L;
            for (int i = 0; i < quarry.efficiencyLevel() + 1; ++i) {
                action.tick((Level)quarry.getTargetWorld(), (PowerTile)quarry, energy);
            }
            if (action.isFinished()) {
                quarry.target = null;
                quarry.setState(FINISHED, state);
            }
        }
    };

    public final boolean isWorking;
    private static final Logger LOGGER;
    private static final Marker MARKER;

    private QuarryState(boolean isWorking) {
        this.isWorking = isWorking;
    }

    public abstract void tick(Level var1, BlockPos var2, BlockState var3, TileQuarry var4);

    @Nullable
    private static BlockPos dropUntilPos(Target target, Predicate<BlockPos> condition) {
        BlockPos pos = target.get(false);
        while (pos != null && condition.test(pos)) {
            pos = target.goNextAndGet();
        }
        return pos;
    }

    private static Set<BlockPos> countFluid(Level world, BlockPos originalPos, Area area) {
        HashSet<BlockPos> counted = new HashSet<BlockPos>();
        EnumSet<Direction> directions = EnumSet.of(Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP);
        Set<BlockPos> search = Set.of(originalPos);
        HashSet<BlockPos> checked = new HashSet<BlockPos>(area.sizeOfEachY());
        while (!search.isEmpty()) {
            HashSet<BlockPos> nextSearch = new HashSet<BlockPos>();
            for (BlockPos pos : search) {
                checked.add(pos);
                if (world.getFluidState(pos).isEmpty() || !counted.add(pos)) continue;
                directions.stream().map(arg_0 -> ((BlockPos)pos).relative(arg_0)).filter(area::isInAreaIgnoreY).filter(Predicate.not(checked::contains)).forEach(nextSearch::add);
            }
            search = nextSearch;
        }
        return counted;
    }

    static int headInterval(TileQuarry quarry) {
        return (int)Math.ceil(1.0 / quarry.headSpeed());
    }

    void logTargetChange(BlockPos quarryPos, TileQuarry quarry) {
        LOGGER.debug(MARKER, "{}({}) Target changed to {} in {}.", (Object)quarry.getClass().getSimpleName(), (Object)quarryPos, (Object)quarry.target, (Object)this.name());
    }

    static {
        LOGGER = QuarryPlus.LOGGER;
        MARKER = MarkerManager.getMarker((String)"QuarryState");
    }
}

