/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.misc.SlotContainer;
import com.yogpc.qp.machines.quarry.SFQuarryEntity;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class SFQuarryMenu
extends AbstractContainerMenu {
    public static final String GUI_ID = "quarryplus:gui_solid_fuel_quarry";
    final DataSlot fuelCountData = this.addDataSlot(DataSlot.standalone());
    @NotNull
    final SFQuarryEntity quarry;
    private final int allSlots;

    public SFQuarryMenu(int id, Player player, BlockPos pos) {
        super(Holder.SOLID_FUEL_QUARRY_MENU_TYPE, id);
        this.quarry = Objects.requireNonNull((SFQuarryEntity)player.level.getBlockEntity(pos));
        this.allSlots = this.quarry.fuelContainer.getContainerSize();
        this.addSlot(new SlotContainer((Container)this.quarry.fuelContainer, 0, 44, 27));
        int oneBox = 18;
        for (int h = 0; h < 3; ++h) {
            for (int v = 0; v < 9; ++v) {
                this.addSlot(new Slot((Container)player.getInventory(), v + h * 9 + 9, 8 + v * oneBox, 84 + h * oneBox));
            }
        }
        for (int vertical = 0; vertical < 9; ++vertical) {
            this.addSlot(new Slot((Container)player.getInventory(), vertical, 8 + vertical * oneBox, 142));
        }
    }

    public boolean stillValid(Player player) {
        return this.quarry.enabled;
    }

    public void broadcastChanges() {
        this.fuelCountData.set(Math.min(this.quarry.fuelCount, Short.MAX_VALUE));
        super.broadcastChanges();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = this.getSlot(index);
        if (slot.hasItem()) {
            ItemStack remain = slot.getItem();
            ItemStack slotContent = remain.copy();
            if (index < this.allSlots ? !this.moveItemStackTo(remain, this.allSlots, 36 + this.allSlots, true) : !this.moveItemStackTo(remain, 0, this.allSlots, false)) {
                return ItemStack.EMPTY;
            }
            if (remain.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (remain.getCount() == slotContent.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, remain);
            return slotContent;
        }
        return ItemStack.EMPTY;
    }
}

