/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.quarry.DigTarget;
import com.yogpc.qp.machines.quarry.FillerTarget;
import com.yogpc.qp.machines.quarry.FrameInsideTarget;
import com.yogpc.qp.machines.quarry.FrameTarget;
import com.yogpc.qp.machines.quarry.PosesTarget;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Target {
    static boolean THROW_IF_INVALID_NBT = !FMLEnvironment.production;
    private final Set<BlockPos> skippedPoses = new HashSet<BlockPos>();

    @Nullable
    public abstract BlockPos get(boolean var1);

    public final BlockPos goNextAndGet() {
        this.get(true);
        return this.get(false);
    }

    @NotNull
    public abstract Stream<BlockPos> allPoses();

    @NotNull
    protected abstract CompoundTag toNbt();

    public static CompoundTag toNbt(Target target) {
        CompoundTag tag = target.toNbt();
        tag.putString("target", target.getClass().getSimpleName());
        return tag;
    }

    public void addSkipped(BlockPos pos) {
        this.skippedPoses.add(pos);
    }

    public boolean alreadySkipped(BlockPos pos) {
        return this.skippedPoses.contains(pos);
    }

    public abstract double progress();

    public static Target fromNbt(CompoundTag tag) {
        return switch (tag.getString("target")) {
            case "DigTarget" -> DigTarget.from(tag);
            case "FrameTarget" -> FrameTarget.from(tag);
            case "PosesTarget" -> PosesTarget.from(tag);
            case "FrameInsideTarget" -> FrameInsideTarget.from(tag);
            case "FillerTarget" -> FillerTarget.from(tag);
            default -> {
                if (THROW_IF_INVALID_NBT) {
                    throw new IllegalArgumentException("Invalid target nbt. " + String.valueOf(tag));
                }
                QuarryPlus.LOGGER.error("Invalid target nbt in Quarry Target. %s".formatted(tag));
                yield null;
            }
        };
    }

    public static Target newFrameTarget(Area area) {
        return new FrameTarget(area);
    }

    public static Target newDigTarget(Area area, int y) {
        return new DigTarget(area, y);
    }

    public static Target newFrameInside(Area area, int minY, int maxY) {
        return new FrameInsideTarget(area, minY, maxY);
    }

    public static Target newFillerTarget(Area area) {
        return new FillerTarget(area);
    }

    @Nullable
    public static Target nextY(@Nullable Target previous, Area area, int digMinY) {
        if (previous instanceof DigTarget) {
            DigTarget digTarget = (DigTarget)previous;
            int nextY = digTarget.y - 1;
            if (digMinY < nextY && nextY <= area.maxY()) {
                return Target.newDigTarget(digTarget.area, nextY);
            }
            return null;
        }
        if (previous instanceof PosesTarget) {
            PosesTarget posesTarget = (PosesTarget)previous;
            int nextY = posesTarget.allPoses().mapToInt(Vec3i::getY).max().orElse(area.minY()) - 1;
            if (digMinY < nextY && nextY <= area.maxY()) {
                return Target.newDigTarget(area, nextY);
            }
            return null;
        }
        return Target.newDigTarget(area, area.minY());
    }

    @NotNull
    public static Target poses(List<BlockPos> pos) {
        return new PosesTarget(pos);
    }
}

