/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.google.common.collect.Sets;
import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.BreakResult;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.EnchantmentHolder;
import com.yogpc.qp.machines.EnchantmentLevel;
import com.yogpc.qp.machines.ItemConverter;
import com.yogpc.qp.machines.MachineStorage;
import com.yogpc.qp.machines.PowerConfig;
import com.yogpc.qp.machines.PowerManager;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.QuarryFakePlayer;
import com.yogpc.qp.machines.module.ModuleInventory;
import com.yogpc.qp.machines.module.QuarryModule;
import com.yogpc.qp.machines.module.QuarryModuleProvider;
import com.yogpc.qp.machines.module.ReplacerModule;
import com.yogpc.qp.machines.quarry.QuarryState;
import com.yogpc.qp.machines.quarry.Target;
import com.yogpc.qp.packet.ClientSync;
import com.yogpc.qp.packet.ClientSyncMessage;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.utils.CacheEntry;
import com.yogpc.qp.utils.MapMulti;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class TileQuarry
extends PowerTile
implements CheckerLog,
MachineStorage.HasStorage,
EnchantmentLevel.HasEnchantments,
ClientSync,
ModuleInventory.HasModuleInventory,
PowerConfig.Provider {
    private static final Marker MARKER = MarkerManager.getMarker((String)"TileQuarry");
    @Nullable
    public Target target;
    public QuarryState state = QuarryState.FINISHED;
    @Nullable
    private Area area;
    private List<EnchantmentLevel> enchantments = new ArrayList<EnchantmentLevel>();
    public final MachineStorage storage = new MachineStorage();
    public double headX;
    public double headY;
    public double headZ;
    private boolean init = false;
    public int digMinY = 0;
    private final ItemConverter itemConverter = ItemConverter.defaultConverter();
    private Set<QuarryModule> modules = new HashSet<QuarryModule>();
    private final ModuleInventory moduleInventory;
    private final QuarryCache cache = new QuarryCache();

    public TileQuarry(BlockPos pos, BlockState state) {
        super(Holder.QUARRY_TYPE, pos, state);
        this.moduleInventory = new ModuleInventory(5, this::updateModules, m -> true, (ModuleInventory.HasModuleInventory)this);
    }

    TileQuarry(BlockEntityType<?> entityType, BlockPos pos, BlockState state) {
        super(entityType, pos, state);
        this.moduleInventory = new ModuleInventory(0, () -> {}, m -> false, (ModuleInventory.HasModuleInventory)this);
    }

    @Override
    public void saveNbtData(CompoundTag nbt) {
        if (this.target != null) {
            nbt.put("target", (Tag)Target.toNbt(this.target));
        }
        nbt.putString("state", this.state.name());
        if (this.area != null) {
            nbt.put("area", (Tag)this.area.toNBT());
        }
        CompoundTag enchantments = new CompoundTag();
        this.enchantments.forEach(e -> enchantments.putInt(Objects.requireNonNull(e.enchantmentID(), "Invalid enchantment. " + String.valueOf(e.enchantment())).toString(), e.level()));
        nbt.put("enchantments", (Tag)enchantments);
        nbt.putDouble("headX", this.headX);
        nbt.putDouble("headY", this.headY);
        nbt.putDouble("headZ", this.headZ);
        nbt.put("storage", (Tag)this.storage.toNbt());
        nbt.putInt("digMinY", this.digMinY);
        nbt.put("moduleInventory", (Tag)this.moduleInventory.serializeNBT());
    }

    @Override
    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.target = nbt.contains("target") ? Target.fromNbt(nbt.getCompound("target")) : null;
        this.state = QuarryState.valueOf(nbt.getString("state"));
        this.area = Area.fromNBT(nbt.getCompound("area")).orElse(null);
        CompoundTag enchantments = nbt.getCompound("enchantments");
        this.setEnchantments(enchantments.getAllKeys().stream().mapMulti(MapMulti.getEntry(ForgeRegistries.ENCHANTMENTS, arg_0 -> ((CompoundTag)enchantments).getInt(arg_0))).map(EnchantmentLevel::new).sorted(EnchantmentLevel.QUARRY_ENCHANTMENT_COMPARATOR).toList());
        this.headX = nbt.getDouble("headX");
        this.headY = nbt.getDouble("headY");
        this.headZ = nbt.getDouble("headZ");
        this.storage.readNbt(nbt.getCompound("storage"));
        this.digMinY = nbt.getInt("digMinY");
        this.moduleInventory.deserializeNBT(nbt.getCompound("moduleInventory"));
        this.init = true;
    }

    @Override
    public CompoundTag toClientTag(CompoundTag tag) {
        if (this.area != null) {
            tag.put("area", (Tag)this.area.toNBT());
        }
        tag.putString("state", this.state.name());
        tag.putDouble("headX", this.headX);
        tag.putDouble("headY", this.headY);
        tag.putDouble("headZ", this.headZ);
        return tag;
    }

    @Override
    public void fromClientTag(CompoundTag tag) {
        this.area = Area.fromNBT(tag.getCompound("area")).orElse(null);
        this.state = QuarryState.valueOf(tag.getString("state"));
        this.headX = tag.getDouble("headX");
        this.headY = tag.getDouble("headY");
        this.headZ = tag.getDouble("headZ");
    }

    public CompoundTag getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && !this.level.isClientSide) {
            this.init = true;
            this.updateModules();
        }
    }

    public void setArea(@Nullable Area area) {
        this.area = area;
        QuarryPlus.LOGGER.debug(MARKER, "{}({}) Area changed to {}.", (Object)this.getClass().getSimpleName(), (Object)this.getBlockPos(), (Object)area);
        if (area != null) {
            this.headX = area.maxX();
            this.headY = area.minY();
            this.headZ = area.maxZ();
        }
    }

    @Nullable
    public Area getArea() {
        return this.area;
    }

    public void setState(QuarryState quarryState, BlockState blockState) {
        if (this.state != quarryState) {
            QuarryState pre = this.state;
            this.state = quarryState;
            this.sync();
            if (this.level != null) {
                this.level.setBlock(this.getBlockPos(), (BlockState)blockState.setValue((Property)QPBlock.WORKING, (Comparable)Boolean.valueOf(quarryState.isWorking)), 3);
                if (!this.level.isClientSide && !quarryState.isWorking) {
                    this.logUsage();
                }
            }
            if (pre != QuarryState.MOVE_HEAD && pre != QuarryState.BREAK_BLOCK && pre != QuarryState.REMOVE_FLUID || quarryState == QuarryState.FILLER) {
                QuarryPlus.LOGGER.debug(MARKER, "{}({}) State changed from {} to {}.", (Object)this.getClass().getSimpleName(), (Object)this.getBlockPos(), (Object)pre, (Object)quarryState);
            }
        }
    }

    public ServerLevel getTargetWorld() {
        return (ServerLevel)this.getLevel();
    }

    public static void tick(Level world, BlockPos pos, BlockState state, TileQuarry quarry) {
        if (quarry.hasEnoughEnergy()) {
            if (quarry.init) {
                quarry.updateModules();
                quarry.init = false;
            }
            for (int i = 0; i < quarry.getRepeatWorkCount(); ++i) {
                quarry.state.tick(world, pos, state, quarry);
            }
        }
    }

    public BreakResult breakBlock(BlockPos targetPos) {
        return this.breakBlock(targetPos, true);
    }

    public BreakResult breakBlock(BlockPos targetPos, boolean requireEnergy) {
        ServerLevel targetWorld = this.getTargetWorld();
        if (targetPos.getX() % 3 == 0 && targetPos.getZ() % 3 == 0) {
            targetWorld.getEntitiesOfClass(ItemEntity.class, new AABB(targetPos).inflate(5.0), Predicate.not(i -> i.getItem().isEmpty())).forEach(i -> {
                this.storage.addItem(i.getItem());
                i.kill();
            });
            this.getExpModule().ifPresent(e -> targetWorld.getEntitiesOfClass(ExperienceOrb.class, new AABB(targetPos).inflate(5.0), EntitySelector.ENTITY_STILL_ALIVE).forEach(orb -> {
                e.addExp(orb.getValue());
                orb.kill();
            }));
        }
        ItemStack pickaxe = this.getPickaxe();
        FakePlayer fakePlayer = QuarryFakePlayer.get(targetWorld);
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, pickaxe);
        BlockState state = targetWorld.getBlockState(targetPos);
        BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent((Level)targetWorld, targetPos, state, (Player)fakePlayer);
        MinecraftForge.EVENT_BUS.post((Event)breakEvent);
        if (breakEvent.isCanceled()) {
            if (this.target != null) {
                this.target.addSkipped(targetPos);
            }
            return BreakResult.FAIL_EVENT;
        }
        if (state.isAir() || !this.canBreak((Level)targetWorld, targetPos, state)) {
            return BreakResult.SKIPPED;
        }
        if (this.hasPumpModule()) {
            TileQuarry.removeEdgeFluid(targetPos, targetWorld, this);
        }
        float hardness = state.getDestroySpeed((BlockGetter)targetWorld, targetPos);
        long requiredEnergy = PowerManager.getBreakEnergy(hardness, this);
        if (requireEnergy && !this.useEnergy(requiredEnergy, PowerTile.Reason.BREAK_BLOCK, requiredEnergy > this.getMaxEnergy())) {
            return BreakResult.NOT_ENOUGH_ENERGY;
        }
        List drops = Block.getDrops((BlockState)state, (ServerLevel)targetWorld, (BlockPos)targetPos, (BlockEntity)targetWorld.getBlockEntity(targetPos), (Entity)fakePlayer, (ItemStack)pickaxe);
        drops.stream().map(this.itemConverter::map).forEach(this.storage::addItem);
        targetWorld.setBlock(targetPos, this.getReplacementState(), 3);
        if (breakEvent.getExpToDrop() > 0) {
            this.getExpModule().ifPresent(e -> {
                if (requireEnergy) {
                    this.useEnergy(PowerManager.getExpCollectEnergy(breakEvent.getExpToDrop(), this), PowerTile.Reason.EXP_COLLECT, true);
                }
                e.addExp(breakEvent.getExpToDrop());
            });
        }
        SoundType sound = state.getSoundType();
        if (requireEnergy) {
            targetWorld.playSound(null, targetPos, sound.getBreakSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 4.0f, sound.getPitch() * 0.8f);
        }
        return BreakResult.SUCCESS;
    }

    static void removeEdgeFluid(BlockPos targetPos, ServerLevel targetWorld, TileQuarry quarry) {
        boolean flagMaxZ;
        Area area = quarry.getArea();
        assert (area != null);
        boolean flagMinX = targetPos.getX() - 1 == area.minX();
        boolean flagMaxX = targetPos.getX() + 1 == area.maxX();
        boolean flagMinZ = targetPos.getZ() - 1 == area.minZ();
        boolean bl = flagMaxZ = targetPos.getZ() + 1 == area.maxZ();
        if (flagMinX) {
            TileQuarry.removeFluidAtPos(targetWorld, new BlockPos(area.minX(), targetPos.getY(), targetPos.getZ()), quarry);
        }
        if (flagMaxX) {
            TileQuarry.removeFluidAtPos(targetWorld, new BlockPos(area.maxX(), targetPos.getY(), targetPos.getZ()), quarry);
        }
        if (flagMinZ) {
            TileQuarry.removeFluidAtPos(targetWorld, new BlockPos(targetPos.getX(), targetPos.getY(), area.minZ()), quarry);
        }
        if (flagMaxZ) {
            TileQuarry.removeFluidAtPos(targetWorld, new BlockPos(targetPos.getX(), targetPos.getY(), area.maxZ()), quarry);
        }
        if (flagMinX && flagMinZ) {
            TileQuarry.removeFluidAtPos(targetWorld, new BlockPos(area.minX(), targetPos.getY(), area.minZ()), quarry);
        }
        if (flagMinX && flagMaxZ) {
            TileQuarry.removeFluidAtPos(targetWorld, new BlockPos(area.minX(), targetPos.getY(), area.maxZ()), quarry);
        }
        if (flagMaxX && flagMinZ) {
            TileQuarry.removeFluidAtPos(targetWorld, new BlockPos(area.maxX(), targetPos.getY(), area.minZ()), quarry);
        }
        if (flagMaxX && flagMaxZ) {
            TileQuarry.removeFluidAtPos(targetWorld, new BlockPos(area.maxX(), targetPos.getY(), area.maxZ()), quarry);
        }
    }

    private static void removeFluidAtPos(ServerLevel world, BlockPos pos, TileQuarry quarry) {
        BlockState state = world.getBlockState(pos);
        FluidState fluidState = world.getFluidState(pos);
        if (!fluidState.isEmpty()) {
            Block block = state.getBlock();
            if (block instanceof BucketPickup) {
                BucketPickup fluidBlock = (BucketPickup)block;
                quarry.useEnergy(PowerManager.getBreakBlockFluidEnergy(quarry), PowerTile.Reason.REMOVE_FLUID, true);
                ItemStack bucketItem = fluidBlock.pickupBlock((LevelAccessor)world, pos, state);
                quarry.storage.addFluid(bucketItem);
                if (world.getBlockState(pos).isAir() || fluidBlock instanceof LiquidBlock && !fluidState.isSource()) {
                    world.setBlock(pos, Holder.BLOCK_FRAME.getDammingState(), 3);
                }
            } else if (state.getBlock() instanceof LiquidBlockContainer) {
                float hardness = state.getDestroySpeed((BlockGetter)world, pos);
                quarry.useEnergy(PowerManager.getBreakEnergy(hardness, quarry), PowerTile.Reason.REMOVE_FLUID, true);
                List drops = Block.getDrops((BlockState)state, (ServerLevel)world, (BlockPos)pos, (BlockEntity)world.getBlockEntity(pos), null, (ItemStack)quarry.getPickaxe());
                drops.forEach(quarry.storage::addItem);
                world.setBlock(pos, Holder.BLOCK_FRAME.getDammingState(), 3);
            }
        }
    }

    public void setEnchantments(Map<Enchantment, Integer> enchantments) {
        this.setEnchantments(enchantments.entrySet().stream().map(EnchantmentLevel::new).sorted(EnchantmentLevel.QUARRY_ENCHANTMENT_COMPARATOR).toList());
    }

    public void setEnchantments(List<EnchantmentLevel> enchantments) {
        this.enchantments = enchantments;
        this.cache.enchantments.expire();
        this.setMaxEnergy(this.getPowerConfig().maxEnergy() * (long)(this.efficiencyLevel() + 1));
    }

    public void setTileDataFromItem(@Nullable CompoundTag tileData) {
        if (tileData == null) {
            this.digMinY = this.level == null ? 0 : this.level.getMinBuildHeight();
            return;
        }
        this.digMinY = tileData.contains("digMinY") ? tileData.getInt("digMinY") : (this.level == null ? 0 : this.level.getMinBuildHeight());
    }

    public CompoundTag getTileDataForItem() {
        CompoundTag tag = new CompoundTag();
        if (this.digMinY != 0) {
            tag.putInt("digMinY", this.digMinY);
        }
        return tag;
    }

    double headSpeed() {
        int l = this.efficiencyLevel();
        return TileQuarry.headSpeed(l);
    }

    @VisibleForTesting
    static double headSpeed(int efficiency) {
        if (efficiency >= 4) {
            return Math.pow(2.0, efficiency - 4);
        }
        return Math.pow(1.681792830507429, efficiency) / 8.0;
    }

    void updateModules() {
        Set blockModules = this.level != null ? QuarryModuleProvider.Block.getModulesInWorld(this.level, this.getBlockPos()) : Collections.emptySet();
        Set<QuarryModule> itemModules = Set.copyOf(this.moduleInventory.getModules());
        this.modules = Sets.union(blockModules, itemModules);
    }

    BlockState getReplacementState() {
        return this.cache.replaceState.getValue(this.level);
    }

    public boolean canBreak(Level targetWorld, BlockPos targetPos, BlockState state) {
        boolean unbreakable;
        if (this.target != null && this.target.alreadySkipped(targetPos)) {
            return false;
        }
        if (state.isAir()) {
            return true;
        }
        boolean bl = unbreakable = state.getDestroySpeed((BlockGetter)targetWorld, targetPos) < 0.0f;
        if (unbreakable) {
            if (this.hasBedrockModule() && state.getBlock() == Blocks.BEDROCK) {
                int worldBottom = targetWorld.getMinBuildHeight();
                if (targetWorld.dimension().equals((Object)Level.NETHER)) {
                    return worldBottom < targetPos.getY() && targetPos.getY() < worldBottom + 5 || 122 < targetPos.getY() && targetPos.getY() < this.cache.netherTop.getValue(targetWorld);
                }
                return worldBottom < targetPos.getY() && targetPos.getY() < worldBottom + 5;
            }
            return false;
        }
        if (TileQuarry.isFullFluidBlock(state)) {
            return this.hasPumpModule();
        }
        return this.getReplacementState() != state;
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        return Stream.of("%sArea:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.area), "%sTarget:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.target), "%sState:%s %s".formatted(new Object[]{ChatFormatting.GREEN, ChatFormatting.RESET, this.state}), "%sRemoveBedrock:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.hasBedrockModule()), "%sDigMinY:%s %d".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.digMinY), "%sHead:%s (%f, %f, %f)".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.headX, this.headY, this.headZ), "%sModules:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.modules), "%sProgressY:%s %.2f".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.yProgress()), "%sCurrentWorkProgress:%s %.2f".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.xzProgress()), this.energyString()).map(TextComponent::new).toList();
    }

    private double yProgress() {
        int totalY = this.getBlockPos().getY() - this.digMinY;
        int currentY = Optional.ofNullable(this.target).map(t -> t.get(false)).map(Vec3i::getY).orElse(this.getBlockPos().getY());
        return (double)(this.getBlockPos().getY() - currentY) / (double)totalY;
    }

    private double xzProgress() {
        if (this.target != null) {
            return this.target.progress();
        }
        return 0.0;
    }

    @Override
    public MachineStorage getStorage() {
        return this.storage;
    }

    @Override
    public List<EnchantmentLevel> getEnchantments() {
        return Collections.unmodifiableList(this.enchantments);
    }

    public void sync() {
        if (this.level != null && !this.level.isClientSide) {
            PacketHandler.sendToClient(new ClientSyncMessage(this), this.level);
        }
    }

    public AABB getRenderBoundingBox() {
        if (this.area != null) {
            int min = this.level != null ? this.level.getMinBuildHeight() : 0;
            return new AABB((double)this.area.minX(), (double)min, (double)this.area.minZ(), (double)this.area.maxX(), (double)this.area.maxY(), (double)this.area.maxZ());
        }
        return new AABB(this.getBlockPos(), this.getBlockPos().offset(1, 1, 1));
    }

    @Override
    public ModuleInventory getModuleInventory() {
        return this.moduleInventory;
    }

    @Override
    public Set<QuarryModule> getLoadedModules() {
        return this.modules;
    }

    @Override
    public int efficiencyLevel() {
        return this.cache.enchantments.getValue(this.getLevel()).efficiency();
    }

    @Override
    public int unbreakingLevel() {
        return this.cache.enchantments.getValue(this.getLevel()).unbreaking();
    }

    @Override
    public int fortuneLevel() {
        return this.cache.enchantments.getValue(this.getLevel()).fortune();
    }

    @Override
    public int silktouchLevel() {
        return this.cache.enchantments.getValue(this.getLevel()).silktouch();
    }

    private class QuarryCache {
        final CacheEntry<BlockState> replaceState = CacheEntry.supplierCache(5L, () -> TileQuarry.this.getReplacerModule().map(ReplacerModule::getState).orElse(Blocks.AIR.defaultBlockState()));
        final CacheEntry<Integer> netherTop = CacheEntry.supplierCache(100L, () -> ((ForgeConfigSpec.IntValue)QuarryPlus.config.common.netherTop).get());
        final CacheEntry<EnchantmentHolder> enchantments = CacheEntry.supplierCache(1000L, () -> EnchantmentHolder.makeHolder(TileQuarry.this));
    }
}

