/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.workbench;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.workbench.TileWorkbench;
import com.yogpc.qp.machines.workbench.WorkbenchRecipe;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerWorkbench
extends AbstractContainerMenu {
    final TileWorkbench tile;
    private static final int sourceSlot = 27;
    private static final int recipeSlot = 18;
    private static final int playerSlot = 36;
    final DataSlot progress = this.addDataSlot(DataSlot.standalone());
    final DataSlot isWorking = this.addDataSlot(DataSlot.standalone());
    final DataSlot workContinue = this.addDataSlot(DataSlot.standalone());
    final DataSlot recipeIndex = this.addDataSlot(DataSlot.standalone());

    public ContainerWorkbench(int id, Player player, BlockPos pos) {
        super(Holder.WORKBENCH_MENU_TYPE, id);
        int col;
        int row;
        this.tile = Objects.requireNonNull((TileWorkbench)player.level.getBlockEntity(pos));
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)this.tile, col + row * 9, 8 + col * 18, 18 + row * 18));
            }
        }
        for (row = 0; row < 2; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)this.tile, col + row * 9 + 27, 8 + col * 18, 90 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)player.getInventory(), col + row * 9 + 9, 8 + col * 18, 140 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)player.getInventory(), col, 8 + col * 18, 198));
        }
        if (!player.level.isClientSide) {
            this.setTrackValues();
            this.tile.startOpen(player);
        }
    }

    private void setTrackValues() {
        this.progress.set(this.tile.getProgressScaled(160));
        this.isWorking.set(this.tile.getRecipe().hasContent() ? 1 : 0);
        this.workContinue.set(this.tile.workContinue ? 1 : 0);
        this.recipeIndex.set(this.tile.recipesList.indexOf(this.tile.getRecipe()));
    }

    public boolean stillValid(Player playerIn) {
        return this.tile.stillValid(playerIn);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        if (27 <= index && index < 45) {
            return ItemStack.EMPTY;
        }
        ItemStack src = ItemStack.EMPTY;
        Slot slot = this.getSlot(index);
        if (slot.hasItem()) {
            ItemStack remain = slot.getItem();
            src = remain.copy();
            if (index < 27) {
                if (src.isStackable()) {
                    if (!this.moveItemStackTo(remain, 45, 81, true)) {
                        return ItemStack.EMPTY;
                    }
                } else {
                    for (int i = 80; i >= 45 && !remain.isEmpty(); --i) {
                        int maxSize;
                        Slot destinationSlot = this.getSlot(i);
                        if (!destinationSlot.hasItem()) {
                            int maxSize2 = Math.min(slot.getMaxStackSize(), remain.getMaxStackSize());
                            destinationSlot.set(remain.split(maxSize2));
                            continue;
                        }
                        ItemStack dest = destinationSlot.getItem();
                        if (!ItemStack.isSameItemSameTags((ItemStack)dest, (ItemStack)remain)) continue;
                        int newSize = dest.getCount() + remain.getCount();
                        if (newSize <= (maxSize = Math.min(slot.getMaxStackSize(), remain.getMaxStackSize()))) {
                            remain.setCount(0);
                            dest.setCount(newSize);
                            slot.setChanged();
                            continue;
                        }
                        if (dest.getCount() >= maxSize) continue;
                        remain.shrink(maxSize - dest.getCount());
                        dest.setCount(maxSize);
                        slot.setChanged();
                    }
                    if (!remain.isEmpty()) {
                        slot.setChanged();
                        return ItemStack.EMPTY;
                    }
                }
            } else if (!this.n_moveItemStackTo(remain)) {
                return ItemStack.EMPTY;
            }
            if (remain.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (remain.getCount() == src.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, remain);
        }
        return src;
    }

    public void broadcastChanges() {
        if (this.tile != null) {
            this.setTrackValues();
        }
        super.broadcastChanges();
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (27 <= slotId && slotId < 45 && clickTypeIn == ClickType.PICKUP) {
            int index = slotId - 27;
            if (index < this.tile.recipesList.size()) {
                if (dragType == 0) {
                    ResourceLocation newRecipeId = this.tile.recipesList.get(index).getId();
                    if (newRecipeId.equals((Object)this.tile.getRecipe().getId())) {
                        this.tile.workContinue = !this.tile.workContinue;
                    } else {
                        this.tile.setCurrentRecipe(newRecipeId);
                    }
                } else if (dragType == 1) {
                    this.tile.setCurrentRecipe(WorkbenchRecipe.dummyRecipe().getId());
                }
            }
        } else if (0 <= slotId && slotId < 27 && clickTypeIn == ClickType.PICKUP) {
            Slot slot = this.getSlot(slotId);
            ItemStack slotStack = slot.getItem();
            ItemStack carrying = this.getCarried();
            if (slotStack.isEmpty()) {
                if (!carrying.isEmpty() && slot.mayPlace(carrying)) {
                    int l2;
                    int n = l2 = dragType == 0 ? carrying.getCount() : 1;
                    if (l2 > slot.getMaxStackSize(carrying)) {
                        l2 = slot.getMaxStackSize(carrying);
                    }
                    slot.set(carrying.split(l2));
                }
            } else if (carrying.isEmpty()) {
                int k2 = dragType == 0 ? Math.min(slotStack.getCount(), slotStack.getMaxStackSize()) : Math.min((slotStack.getCount() + 1) / 2, slotStack.getMaxStackSize());
                this.setCarried(slot.remove(k2));
                if (slotStack.isEmpty()) {
                    slot.set(ItemStack.EMPTY);
                }
                slot.onTake(player, this.getCarried());
            } else if (ItemStack.isSameItemSameTags((ItemStack)slotStack, (ItemStack)carrying)) {
                int j2 = dragType == 0 ? carrying.getCount() : 1;
                carrying.shrink(j2);
                slotStack.grow(j2);
            }
            slot.setChanged();
        } else if (clickTypeIn != ClickType.SWAP) {
            super.clicked(slotId, dragType, clickTypeIn, player);
        }
    }

    protected boolean n_moveItemStackTo(ItemStack stack) {
        int i;
        boolean flag = false;
        for (i = 0; i < 27 && !stack.isEmpty(); ++i) {
            int maxSize;
            Slot slot = this.getSlot(i);
            ItemStack itemstack = slot.getItem();
            if (itemstack.isEmpty() || !ItemStack.isSameItemSameTags((ItemStack)stack, (ItemStack)itemstack)) continue;
            int j = itemstack.getCount() + stack.getCount();
            if (j <= (maxSize = slot.getMaxStackSize())) {
                stack.setCount(0);
                itemstack.setCount(j);
                slot.setChanged();
                flag = true;
                continue;
            }
            if (itemstack.getCount() >= maxSize) continue;
            if (QuarryPlus.config.debug()) {
                QuarryPlus.LOGGER.info("ContainerWorkbench#mergeItemStack itemStack.getCount() < maxSize");
            }
            stack.shrink(maxSize - itemstack.getCount());
            itemstack.setCount(maxSize);
            slot.setChanged();
            flag = true;
        }
        if (!stack.isEmpty()) {
            for (i = 0; i < 27; ++i) {
                Slot slot1 = this.getSlot(i);
                ItemStack itemStack1 = slot1.getItem();
                if (!itemStack1.isEmpty() || !slot1.mayPlace(stack)) continue;
                slot1.set(stack.split(stack.getCount()));
                slot1.setChanged();
                flag = true;
                break;
            }
        }
        return flag;
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        this.tile.stopOpen(playerIn);
    }
}

