/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.workbench;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class EnchantmentIngredient
extends AbstractIngredient {
    public static final String NAME = "enchantment_ingredient";
    private final ItemStack stack;
    private final List<EnchantmentInstance> enchantments;
    @Nullable
    private final CompoundTag withoutEnchantment;
    private final boolean checkDamage;

    public EnchantmentIngredient(ItemStack stack, List<EnchantmentInstance> enchantments, boolean checkDamage) {
        super(Stream.of(new Ingredient.ItemValue(EnchantmentIngredient.addEnchantments(stack, enchantments))));
        this.stack = stack;
        this.enchantments = enchantments;
        this.withoutEnchantment = EnchantmentIngredient.getTagWithoutEnchantment(stack, checkDamage);
        this.checkDamage = checkDamage;
    }

    public boolean isSimple() {
        return false;
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        Serializer.INSTANCE.write(object, this);
        return object;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (this.stack.getItem() != stack.getItem()) {
            return false;
        }
        Map enchantments = EnchantmentHelper.getEnchantments((ItemStack)stack);
        if (!this.enchantments.stream().allMatch(d -> enchantments.getOrDefault(d.enchantment, 0) >= d.level)) {
            return false;
        }
        if (this.withoutEnchantment == null) {
            return true;
        }
        CompoundTag nbt = EnchantmentIngredient.getTagWithoutEnchantment(stack, this.checkDamage);
        return Objects.equals(this.withoutEnchantment, nbt);
    }

    private static ItemStack addEnchantments(ItemStack stack, List<EnchantmentInstance> enchantments) {
        ItemStack toEnchantment = stack.copy();
        enchantments.forEach(d -> toEnchantment.enchant(d.enchantment, d.level));
        return toEnchantment;
    }

    @Nullable
    private static CompoundTag getTagWithoutEnchantment(ItemStack stack, boolean checkDamage) {
        return Optional.ofNullable(stack.getShareTag()).map(CompoundTag::copy).map(c -> {
            c.remove("Enchantments");
            c.remove("StoredEnchantments");
            if (!checkDamage) {
                c.remove("Damage");
            }
            return c;
        }).filter(Predicate.not(CompoundTag::isEmpty)).orElse(null);
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<EnchantmentIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public EnchantmentIngredient parse(FriendlyByteBuf buffer) {
            ItemStack stack = buffer.readItem();
            int size = buffer.readVarInt();
            List<EnchantmentInstance> data = IntStream.range(0, size).mapToObj(operand -> {
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(buffer.readResourceLocation());
                int level = buffer.readInt();
                return new EnchantmentInstance(Objects.requireNonNull(enchantment), level);
            }).collect(Collectors.toList());
            boolean checkDamage = buffer.readBoolean();
            return new EnchantmentIngredient(stack, data, checkDamage);
        }

        public EnchantmentIngredient parse(JsonObject json) {
            List<Object> data;
            ItemStack stack = CraftingHelper.getItemStack((JsonObject)json, (boolean)true);
            boolean checkDamage = GsonHelper.getAsBoolean((JsonObject)json, (String)"checkDamage", (boolean)false);
            if (json.has("enchantments")) {
                JsonArray enchantmentArray = json.getAsJsonArray("enchantments");
                data = StreamSupport.stream(enchantmentArray.spliterator(), false).map(JsonElement::getAsJsonObject).map(o -> {
                    Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(GsonHelper.getAsString((JsonObject)o, (String)"id")));
                    int level = GsonHelper.getAsInt((JsonObject)o, (String)"level", (int)1);
                    return new EnchantmentInstance(Objects.requireNonNull(enchantment), level);
                }).collect(Collectors.toList());
            } else {
                data = Collections.emptyList();
            }
            return new EnchantmentIngredient(stack, data, checkDamage);
        }

        public void write(FriendlyByteBuf buffer, EnchantmentIngredient ingredient) {
            buffer.writeItemStack(ingredient.stack, false);
            buffer.writeVarInt(ingredient.enchantments.size());
            for (EnchantmentInstance data : ingredient.enchantments) {
                buffer.writeResourceLocation(Objects.requireNonNull(data.enchantment.getRegistryName()));
                buffer.writeInt(data.level);
            }
            buffer.writeBoolean(ingredient.checkDamage);
        }

        public void write(JsonObject json, EnchantmentIngredient ingredient) {
            JsonArray enchantmentArray;
            json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)INSTANCE).toString());
            json.addProperty("item", ingredient.stack.getItem().getRegistryName().toString());
            json.addProperty("count", (Number)ingredient.stack.getCount());
            json.addProperty("checkDamage", Boolean.valueOf(ingredient.checkDamage));
            if (ingredient.withoutEnchantment != null) {
                JsonElement element = (JsonElement)Dynamic.convert((DynamicOps)NbtOps.INSTANCE, (DynamicOps)JsonOps.INSTANCE, (Object)ingredient.withoutEnchantment);
                json.add("nbt", element);
            }
            if ((enchantmentArray = ingredient.enchantments.stream().reduce(new JsonArray(), (jsonElements, enchantmentData) -> {
                JsonObject object = new JsonObject();
                object.addProperty("id", enchantmentData.enchantment.getRegistryName().toString());
                object.addProperty("level", (Number)enchantmentData.level);
                jsonElements.add((JsonElement)object);
                return jsonElements;
            }, (jsonElements, jsonElements2) -> {
                jsonElements.addAll(jsonElements2);
                return jsonElements;
            })).size() != 0) {
                json.add("enchantments", (JsonElement)enchantmentArray);
            }
        }
    }
}

