/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.workbench;

import com.yogpc.qp.machines.workbench.WorkbenchRecipe;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public interface RecipeFinder {
    public Map<ResourceLocation, WorkbenchRecipe> recipes();

    default public int recipeSize() {
        return this.recipes().size();
    }

    default public List<WorkbenchRecipe> getRecipes(List<ItemStack> input) {
        return this.recipes().values().stream().filter(r -> r.hasAllRequiredItems(input)).sorted(WorkbenchRecipe.COMPARATOR).toList();
    }

    default public List<WorkbenchRecipe> findRecipes(ItemStack output) {
        if (output.isEmpty()) {
            return Collections.emptyList();
        }
        return this.recipes().values().stream().filter(r -> ItemStack.isSameItemSameTags((ItemStack)r.getResultItem(), (ItemStack)output)).toList();
    }

    public static <C extends Container, T extends Recipe<C>> Map<ResourceLocation, T> find(RecipeManager manager, RecipeType<T> recipeType) {
        return manager.getAllRecipesFor(recipeType).stream().collect(Collectors.toMap(Recipe::getId, Function.identity()));
    }
}

