/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.workbench;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.yogpc.qp.machines.workbench.ContainerWorkbench;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScreenWorkbench
extends AbstractContainerScreen<ContainerWorkbench> {
    private static final ResourceLocation gui = new ResourceLocation("quarryplus", "textures/gui/workbench.png");

    public ScreenWorkbench(ContainerWorkbench workbench, Inventory inventory, Component component) {
        super((AbstractContainerMenu)workbench, inventory, component);
        this.imageWidth = 176;
        this.imageHeight = 222;
        this.inventoryLabelY = this.imageHeight - 96 + 2;
    }

    protected void renderLabels(PoseStack matrices, int mouseX, int mouseY) {
        super.renderLabels(matrices, mouseX, mouseY);
        if (((ContainerWorkbench)this.getMenu()).tile.getMaxEnergyStored() > 5) {
            String current = ((ContainerWorkbench)this.getMenu()).tile.getEnergyStored() + "FE";
            this.font.draw(matrices, String.format("%s/%d", current, ((ContainerWorkbench)this.getMenu()).tile.getMaxEnergyStored()), (float)(120 - this.font.width(current)), (float)this.inventoryLabelY, 0x404040);
        }
    }

    protected void renderBg(PoseStack matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)gui);
        this.blit(matrices, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.imageWidth, this.imageHeight);
        if (((ContainerWorkbench)this.getMenu()).isWorking.get() == 1) {
            this.blit(matrices, this.getGuiLeft() + 8, this.getGuiTop() + 78, 0, this.imageHeight, ((ContainerWorkbench)this.getMenu()).progress.get(), 4);
            int cur_recipe = 27 + ((ContainerWorkbench)this.getMenu()).recipeIndex.get();
            int i = ((ContainerWorkbench)this.getMenu()).workContinue.get() == 1 ? 16 : 0;
            this.blit(matrices, this.getGuiLeft() + 8 + cur_recipe % 9 * 18, this.getGuiTop() + 90 + (cur_recipe / 9 - 3) * 18, this.imageWidth + i, 0, 16, 16);
        }
    }

    public void render(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.renderBackground(matrices);
        super.render(matrices, mouseX, mouseY, delta);
        this.renderTooltip(matrices, mouseX, mouseY);
    }
}

