/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.workbench;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.InvUtils;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.workbench.ContainerWorkbench;
import com.yogpc.qp.machines.workbench.WorkbenchRecipe;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.TileMessage;
import com.yogpc.qp.utils.MapMulti;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class TileWorkbench
extends PowerTile
implements Container,
MenuProvider,
CheckerLog {
    final List<ItemStack> ingredientInventory = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    final List<ItemStack> selectionInventory = NonNullList.withSize((int)18, (Object)ItemStack.EMPTY);
    public List<WorkbenchRecipe> recipesList = Collections.emptyList();
    private WorkbenchRecipe currentRecipe = WorkbenchRecipe.dummyRecipe();
    private final ItemHandler itemHandler = new ItemHandler();
    public boolean workContinue;
    private Runnable initRecipeTask = null;
    private final List<Player> openPlayers = new ArrayList<Player>();

    public TileWorkbench(BlockPos pos, BlockState state) {
        super(Holder.WORKBENCH_TYPE, pos, state);
    }

    public void tick() {
        if (!this.enabled || this.level == null || this.level.isClientSide) {
            return;
        }
        if (this.initRecipeTask != null) {
            this.initRecipeTask.run();
            this.initRecipeTask = null;
        }
        if (this.currentRecipe.hasContent() && this.currentRecipe.getRequiredEnergy() <= this.getEnergy()) {
            this.useEnergy(this.currentRecipe.getRequiredEnergy(), PowerTile.Reason.WORKBENCH, true);
            ItemStack created = this.currentRecipe.getOutput(this.ingredientInventory);
            ItemStack toSpawnInWorld = InvUtils.injectToNearTile(this.level, this.getBlockPos(), created);
            if (!toSpawnInWorld.isEmpty()) {
                Containers.dropItemStack((Level)this.level, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (ItemStack)toSpawnInWorld);
            }
            this.currentRecipe.consumeItems(this.ingredientInventory);
            this.updateRecipeOutputs();
            this.setCurrentRecipe(this.workContinue ? this.currentRecipe.getId() : WorkbenchRecipe.dummyRecipe().getId());
        } else if (((Boolean)QuarryPlus.config.common.noEnergy.get()).booleanValue()) {
            this.addEnergy(this.currentRecipe.getRequiredEnergy() / 200L, false);
        } else {
            this.addEnergy(5000000000L, false);
        }
        if (!this.openPlayers.isEmpty()) {
            PacketHandler.sendToClient(new TileMessage(this), this.level);
        }
    }

    public void onLoad() {
        MinecraftServer server;
        super.onLoad();
        if (this.level != null && !this.level.isClientSide && this.initRecipeTask != null && (server = this.level.getServer()) != null) {
            server.tell((Runnable)new TickTask(server.getTickCount(), this.initRecipeTask));
            this.initRecipeTask = null;
        }
    }

    @Override
    public void load(CompoundTag nbt) {
        super.load(nbt);
        ListTag list = nbt.getList("Items", 10);
        list.stream().mapMulti(MapMulti.cast(CompoundTag.class)).forEach(nbtTagCompound -> {
            byte slot = nbtTagCompound.getByte("Slot");
            ItemStack stack = ItemStack.of((CompoundTag)nbtTagCompound);
            stack.setCount(nbtTagCompound.getInt("Count"));
            this.ingredientInventory.set(slot, stack);
        });
        ResourceLocation recipeLocation = new ResourceLocation(nbt.getString("recipe"));
        this.initRecipeTask = () -> {
            this.updateRecipeOutputs();
            this.setCurrentRecipe(recipeLocation);
        };
    }

    @Override
    public void saveNbtData(CompoundTag nbt) {
        ListTag items = new ListTag();
        for (int i = 0; i < this.ingredientInventory.size(); ++i) {
            ItemStack stack = this.ingredientInventory.get(i);
            if (stack.isEmpty()) continue;
            CompoundTag compoundNBT = new CompoundTag();
            compoundNBT.putByte("Slot", (byte)i);
            stack.save(compoundNBT);
            compoundNBT.remove("Count");
            compoundNBT.putInt("Count", stack.getCount());
            items.add((Object)compoundNBT);
        }
        nbt.put("Items", (Tag)items);
        nbt.putString("recipe", this.currentRecipe.getId().toString());
    }

    public int getContainerSize() {
        return 45;
    }

    public boolean isEmpty() {
        return this.ingredientInventory.stream().allMatch(ItemStack::isEmpty);
    }

    public ItemStack getItem(int index) {
        if (this.ingredientInventory.size() <= index && index < this.getContainerSize()) {
            return this.selectionInventory.get(index - this.ingredientInventory.size());
        }
        return this.ingredientInventory.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        if (this.ingredientInventory.size() <= index && index < this.getContainerSize()) {
            return ContainerHelper.removeItem(this.selectionInventory, (int)(index - this.ingredientInventory.size()), (int)count);
        }
        ItemStack stack = ContainerHelper.removeItem(this.ingredientInventory, (int)index, (int)count);
        this.updateRecipeOutputs();
        return stack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        if (this.ingredientInventory.size() <= index && index < this.getContainerSize()) {
            return ContainerHelper.takeItem(this.selectionInventory, (int)(index - this.ingredientInventory.size()));
        }
        return ContainerHelper.takeItem(this.ingredientInventory, (int)index);
    }

    public void setItem(int index, ItemStack stack) {
        if (this.ingredientInventory.size() <= index && index < this.getContainerSize()) {
            this.selectionInventory.set(index - this.ingredientInventory.size(), stack);
        } else {
            this.ingredientInventory.set(index, stack);
            this.updateRecipeOutputs();
        }
    }

    public int getMaxStackSize() {
        return Integer.MAX_VALUE;
    }

    public void clearContent() {
        this.ingredientInventory.clear();
        this.updateRecipeOutputs();
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        return Stream.of("%sRecipe:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.currentRecipe), "%sWorkContinue:%s %b".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.workContinue), "%sRecipe List:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.recipesList), this.energyString()).map(TextComponent::new).toList();
    }

    public Component getDisplayName() {
        return this.getBlockState().getBlock().getName();
    }

    public boolean stillValid(Player player) {
        return TileWorkbench.stillValid(this, player);
    }

    public void setChanged() {
        super.setChanged();
        this.updateRecipeOutputs();
    }

    private void updateRecipeOutputs() {
        if (this.level != null && !this.level.isClientSide) {
            this.updateRecipeList();
            if (!this.recipesList.contains(this.currentRecipe) && this.currentRecipe.hasContent()) {
                this.setCurrentRecipe(WorkbenchRecipe.dummyRecipe().getId());
                this.logUsage();
            }
            PacketHandler.sendToClient(new TileMessage(this), this.level);
        }
    }

    @VisibleForTesting
    void updateRecipeList() {
        this.recipesList = WorkbenchRecipe.getRecipeFinder().getRecipes(this.ingredientInventory);
        this.selectionInventory.clear();
        for (int i = 0; i < this.recipesList.size(); ++i) {
            this.setItem(this.ingredientInventory.size() + i, this.recipesList.get(i).getResultItem());
        }
    }

    public void setCurrentRecipe(ResourceLocation recipeName) {
        this.currentRecipe = this.recipesList.stream().filter(r -> recipeName.equals((Object)r.getId())).findFirst().orElse(WorkbenchRecipe.dummyRecipe());
        this.setMaxEnergy(Math.max(this.currentRecipe.getRequiredEnergy(), 5L));
        if (((Boolean)QuarryPlus.config.common.noEnergy.get()).booleanValue()) {
            this.setEnergy(0L, true);
        }
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.itemHandler));
        }
        return super.getCapability(cap, side);
    }

    public WorkbenchRecipe getRecipe() {
        return this.currentRecipe;
    }

    public int getProgressScaled(int scale) {
        if (this.currentRecipe.hasContent()) {
            return (int)(this.getEnergy() * (long)scale / this.currentRecipe.getRequiredEnergy());
        }
        return 0;
    }

    public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
        return new ContainerWorkbench(id, player, this.getBlockPos());
    }

    public void startOpen(Player player) {
        this.openPlayers.add(player);
    }

    public void stopOpen(Player player) {
        this.openPlayers.remove(player);
    }

    private class ItemHandler
    implements IItemHandlerModifiable {
        private ItemHandler() {
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            TileWorkbench.this.setItem(slot, stack);
        }

        public int getSlots() {
            return TileWorkbench.this.ingredientInventory.size();
        }

        public ItemStack getStackInSlot(int slot) {
            return TileWorkbench.this.getItem(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            ItemStack inSlot = this.getStackInSlot(slot).copy();
            if (!inSlot.isEmpty()) {
                if (ItemHandlerHelper.canItemStacksStack((ItemStack)inSlot, (ItemStack)stack)) {
                    if (!simulate) {
                        inSlot.grow(stack.getCount());
                        this.setStackInSlot(slot, inSlot);
                        TileWorkbench.this.setChanged();
                    }
                    return ItemStack.EMPTY;
                }
                return stack;
            }
            if (!simulate) {
                this.setStackInSlot(slot, stack.copy());
                TileWorkbench.this.setChanged();
            }
            return ItemStack.EMPTY;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return TileWorkbench.this.getMaxStackSize();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return TileWorkbench.this.canPlaceItem(slot, stack);
        }
    }
}

