/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector4f;
import com.yogpc.qp.render.ColorBox;

final class Buffer {
    private final VertexConsumer bufferBuilder;
    private final PoseStack matrix;
    private final Vector4f vector4f = new Vector4f();
    private final ColorBox colorBox;

    Buffer(VertexConsumer bufferBuilder, PoseStack matrixStack) {
        this(bufferBuilder, matrixStack, ColorBox.white);
    }

    Buffer(VertexConsumer bufferBuilder, PoseStack matrix, ColorBox colorBox) {
        this.bufferBuilder = bufferBuilder;
        this.matrix = matrix;
        this.colorBox = colorBox;
    }

    Buffer pos(double x, double y, double z) {
        Matrix4f matrix4f = this.matrix.last().pose();
        this.vector4f.set((float)x, (float)y, (float)z, 1.0f);
        this.vector4f.transform(matrix4f);
        this.bufferBuilder.vertex((double)this.vector4f.x(), (double)this.vector4f.y(), (double)this.vector4f.z());
        return this;
    }

    Buffer colored() {
        return this.color(this.colorBox);
    }

    Buffer color(int red, int green, int blue, int alpha) {
        this.bufferBuilder.color(red, green, blue, alpha);
        return this;
    }

    Buffer color(ColorBox colors) {
        this.bufferBuilder.color(colors.red(), colors.green(), colors.blue(), colors.alpha());
        return this;
    }

    Buffer tex(float u, float v) {
        this.bufferBuilder.uv(u, v);
        return this;
    }

    void lightedAndEnd() {
        this.bufferBuilder.overlayCoords(10, 10).uv2(240, 0).normal(0.0f, 1.0f, 0.0f).endVertex();
    }

    boolean bufferEq(VertexConsumer builder) {
        return this.bufferBuilder == builder;
    }
}

