/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yogpc.qp.machines.marker.Tile16Marker;
import com.yogpc.qp.render.Box;
import com.yogpc.qp.render.ColorBox;
import com.yogpc.qp.render.Sprites;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Render16Marker
implements BlockEntityRenderer<Tile16Marker> {
    public Render16Marker(BlockEntityRendererProvider.Context d) {
    }

    public void render(Tile16Marker te, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        Minecraft.getInstance().getProfiler().push("quarryplus");
        Minecraft.getInstance().getProfiler().push("marker16");
        BlockPos markerPos = te.getBlockPos();
        VertexConsumer buffer = vertexConsumers.getBuffer(RenderType.cutoutMipped());
        matrices.pushPose();
        matrices.translate((double)(-markerPos.getX()), (double)(-markerPos.getY()), (double)(-markerPos.getZ()));
        if (te.boxes != null) {
            for (Box box : te.boxes) {
                if (box == null) continue;
                box.render(buffer, matrices, Sprites.INSTANCE.getWhite(), ColorBox.redColor);
            }
        }
        matrices.popPose();
        Minecraft.getInstance().getProfiler().pop();
        Minecraft.getInstance().getProfiler().pop();
    }

    public boolean shouldRenderOffScreen(Tile16Marker blockEntity) {
        return true;
    }
}

