/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yogpc.qp.machines.marker.TileFlexMarker;
import com.yogpc.qp.render.Box;
import com.yogpc.qp.render.ColorBox;
import com.yogpc.qp.render.Sprites;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderFlexMarker
implements BlockEntityRenderer<TileFlexMarker> {
    public RenderFlexMarker(BlockEntityRendererProvider.Context d) {
    }

    public void render(TileFlexMarker te, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        Minecraft.getInstance().getProfiler().push("quarryplus");
        Minecraft.getInstance().getProfiler().push("flex_marker");
        BlockPos markerPos = te.getBlockPos();
        VertexConsumer buffer = vertexConsumers.getBuffer(RenderType.cutoutMipped());
        matrices.pushPose();
        matrices.translate((double)(-markerPos.getX()), (double)(-markerPos.getY()), (double)(-markerPos.getZ()));
        if (te.boxes != null) {
            for (Box box : te.boxes) {
                if (box == null) continue;
                box.render(buffer, matrices, Sprites.INSTANCE.getWhite(), ColorBox.redColor);
            }
        }
        if (te.directionBox != null) {
            te.directionBox.render(buffer, matrices, Sprites.INSTANCE.getWhite(), ColorBox.blueColor);
        }
        matrices.popPose();
        Minecraft.getInstance().getProfiler().pop();
        Minecraft.getInstance().getProfiler().pop();
    }

    public boolean shouldRenderOffScreen(TileFlexMarker blockEntity) {
        return true;
    }
}

