/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.render;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class Sprites {
    public static final Sprites INSTANCE = new Sprites();
    private static final List<String> spriteNames = List.of("laser_1", "laser_2", "laser_3", "laser_4", "white", "stripes_h", "stripes_v", "stripes_blue", "stripes_red", "drill", "drill_head");
    private final Map<String, TextureAtlasSprite> spriteMap = new HashMap<String, TextureAtlasSprite>();

    private Sprites() {
    }

    @SubscribeEvent
    public static void register(TextureStitchEvent.Pre event) {
        if (event.getAtlas().location().equals((Object)InventoryMenu.BLOCK_ATLAS)) {
            spriteNames.stream().map(Sprites::getSpriteLocation).forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
        }
    }

    @SubscribeEvent
    public static void registerSprites(TextureStitchEvent.Post event) {
        if (event.getAtlas().location().equals((Object)InventoryMenu.BLOCK_ATLAS)) {
            spriteNames.forEach(s -> {
                ResourceLocation name = Sprites.getSpriteLocation(s);
                TextureAtlasSprite sprite = event.getAtlas().getSprite(name);
                Sprites.INSTANCE.spriteMap.put((String)s, sprite);
            });
        }
    }

    private TextureAtlasSprite getSprite(String name) {
        return this.spriteMap.computeIfAbsent(name, s -> (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(Sprites.getSpriteLocation(s)));
    }

    @NotNull
    private static ResourceLocation getSpriteLocation(String s) {
        return new ResourceLocation("quarryplus", "entities/" + s);
    }

    public TextureAtlasSprite getMarkerBlue() {
        return this.getSprite("laser_4");
    }

    public TextureAtlasSprite getV() {
        return this.getSprite("stripes_v");
    }

    public TextureAtlasSprite getFrameH() {
        return this.getSprite("stripes_h");
    }

    public TextureAtlasSprite getBoxBlueStripe() {
        return this.getSprite("stripes_blue");
    }

    public TextureAtlasSprite getBoxRedStripe() {
        return this.getSprite("stripes_red");
    }

    public TextureAtlasSprite getDrillStripe() {
        return this.getSprite("drill");
    }

    public TextureAtlasSprite getDrillHeadStripe() {
        return this.getSprite("drill_head");
    }

    public TextureAtlasSprite getWhite() {
        return this.getSprite("white");
    }
}

