package com.yogpc.qp.machines.workbench;

import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.fml.loading.FMLEnvironment;

public final class QuarryDebugCondition implements ICondition {
    public static final ResourceLocation NAME = new ResourceLocation("quarryplus:debug_enabled");

    public QuarryDebugCondition() {
    }

    @Override
    public ResourceLocation getID() {
        return NAME;
    }

    @Override
    @SuppressWarnings("removal")
    public boolean test() {
        return this.test(IContext.EMPTY);
    }

    @Override
    public boolean test(IContext context) {
        return !FMLEnvironment.production;
    }

    public static class Serializer implements IConditionSerializer<QuarryDebugCondition> {

        @Override
        public void write(JsonObject json, QuarryDebugCondition condition) {
        }

        @Override
        public QuarryDebugCondition read(JsonObject json) {
            return new QuarryDebugCondition();
        }

        @Override
        public ResourceLocation getID() {
            return QuarryDebugCondition.NAME;
        }
    }
}
