/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advpump;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

class Target
implements Iterator<BlockPos> {
    private final List<BlockPos> posList;
    private ListIterator<BlockPos> iterator;
    private final Predicate<BlockPos> inRange;

    Target(List<BlockPos> posList, Predicate<BlockPos> inRange) {
        this.posList = posList;
        this.iterator = posList.listIterator();
        this.inRange = inRange;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public BlockPos next() {
        return this.iterator.next();
    }

    Predicate<BlockPos> getPredicate() {
        return this.inRange;
    }

    boolean checkAllFluidsRemoved(Level world, BlockPos center) {
        List<Vec3i> stillFluid = this.posList.stream().mapMulti((pos, consumer) -> {
            consumer.accept(pos);
            consumer.accept(pos.m_7494_());
        }).filter(p -> !world.m_6425_(p).m_76178_()).filter(this.inRange).distinct().sorted(Comparator.comparingInt(Vec3i::m_123342_).reversed().thenComparing(Comparator.comparingInt(arg_0 -> ((BlockPos)center).m_123333_(arg_0)).reversed())).toList();
        if (stillFluid.isEmpty()) {
            return false;
        }
        this.iterator = stillFluid.listIterator();
        return true;
    }

    static Target getTarget(Level world, BlockPos initPos, Predicate<BlockPos> inRange, Predicate<BlockState> isReplaceBlock, int sizeHint) {
        List<BlockPos> result = Target.search(world, Set.of(initPos), inRange, isReplaceBlock, sizeHint);
        result.sort(Comparator.comparingInt(Vec3i::m_123342_).reversed().thenComparing(Comparator.comparingInt(arg_0 -> ((BlockPos)initPos).m_123333_(arg_0)).reversed()));
        return new Target(result, inRange);
    }

    private static List<BlockPos> search(Level world, Set<BlockPos> initialPoses, Predicate<BlockPos> inRange, Predicate<BlockState> isReplaceBlock, int sizeHint) {
        HashSet<BlockPos> counted = new HashSet<BlockPos>(sizeHint);
        HashSet<BlockPos> checked = new HashSet<BlockPos>(sizeHint);
        ArrayList<BlockPos> result = new ArrayList<BlockPos>(sizeHint);
        EnumSet<Direction> directions = EnumSet.of(Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP);
        Set<BlockPos> search = initialPoses;
        while (!search.isEmpty()) {
            HashSet<BlockPos> nextSearch = new HashSet<BlockPos>(sizeHint);
            checked.addAll(search);
            for (BlockPos pos : search) {
                boolean isFluid;
                boolean bl = isFluid = !world.m_6425_(pos).m_76178_();
                if (!isFluid && !isReplaceBlock.test(world.m_8055_(pos)) || !counted.add(pos)) continue;
                if (isFluid) {
                    result.add(pos);
                }
                directions.stream().map(arg_0 -> ((BlockPos)pos).m_142300_(arg_0)).filter(inRange).filter(Predicate.not(checked::contains)).forEach(nextSearch::add);
            }
            search = nextSearch;
        }
        return result;
    }
}

