/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.filler;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.filler.FillerEntity;
import com.yogpc.qp.utils.CombinedBlockEntityTicker;
import com.yogpc.qp.utils.QuarryChunkLoadUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public final class FillerBlock
extends QPBlock
implements EntityBlock {
    public static final String NAME = "filler";

    public FillerBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(1.5f, 10.0f).m_60918_(SoundType.f_56742_), NAME);
    }

    public FillerEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return (FillerEntity)Holder.FILLER_TYPE.m_155264_(pPos, pState);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, blockIn, fromPos, isMoving);
        if (!level.f_46443_ && level.m_46753_(pos)) {
            level.m_141902_(pos, Holder.FILLER_TYPE).ifPresent(f -> f.start(FillerEntity.Action.BOX));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!QuarryPlus.config.enableMap.enabled(NAME)) {
            if (!level.f_46443_) {
                player.m_5661_((Component)new TranslatableComponent("quarryplus.chat.disable_message", new Object[]{this.m_49954_()}), true);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (!player.m_6144_()) {
            BlockEntity blockEntity;
            if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof FillerEntity) {
                FillerEntity filler = (FillerEntity)blockEntity;
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)filler, (BlockPos)pos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.m_6402_(level, pos, state, entity, stack);
        if (!level.f_46443_) {
            level.m_141902_(pos, Holder.FILLER_TYPE).ifPresent(t -> {
                boolean preForced = QuarryChunkLoadUtil.makeChunkLoaded(level, pos, t.enabled);
                t.setChunkPreLoaded(preForced);
            });
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof FillerEntity) {
                FillerEntity filler = (FillerEntity)blockEntity;
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)filler.container);
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, moved);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> entityType) {
        return pLevel.f_46443_ ? null : FillerBlock.checkType(entityType, Holder.FILLER_TYPE, new CombinedBlockEntityTicker(PowerTile.getGenerator(), (l, p, s, t) -> t.tick(), PowerTile.logTicker()));
    }
}

