/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.marker;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.marker.TileMarker;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockMarker
extends QPBlock
implements EntityBlock {
    private static final VoxelShape STANDING_Shape = Shapes.m_83048_((double)0.35, (double)0.0, (double)0.35, (double)0.65, (double)0.65, (double)0.65);
    private static final VoxelShape DOWN_Shape = Shapes.m_83048_((double)0.35, (double)0.35, (double)0.35, (double)0.65, (double)1.0, (double)0.65);
    private static final VoxelShape NORTH_Shape = Shapes.m_83048_((double)0.35, (double)0.35, (double)0.35, (double)0.65, (double)0.65, (double)1.0);
    private static final VoxelShape SOUTH_Shape = Shapes.m_83048_((double)0.35, (double)0.35, (double)0.0, (double)0.65, (double)0.65, (double)0.65);
    private static final VoxelShape WEST_Shape = Shapes.m_83048_((double)0.35, (double)0.35, (double)0.35, (double)1.0, (double)0.65, (double)0.65);
    private static final VoxelShape EAST_Shape = Shapes.m_83048_((double)0.0, (double)0.35, (double)0.35, (double)0.65, (double)0.65, (double)0.65);
    public static final String NAME = "marker";

    public BlockMarker() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60953_(value -> 7).m_60910_(), NAME);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)ctx.m_43719_());
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return Holder.MARKER_TYPE.m_155264_(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof TileMarker) {
            TileMarker marker = (TileMarker)blockEntity;
            marker.tryConnect(true);
            marker.getArea().ifPresent(area -> player.m_5661_((Component)new TextComponent("%sMarker Area%s: %s".formatted(ChatFormatting.AQUA, ChatFormatting.RESET, area)), false));
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_6104_(BlockState state, BlockState stateFrom, Direction direction) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> STANDING_Shape;
            case Direction.DOWN -> DOWN_Shape;
            case Direction.EAST -> EAST_Shape;
            case Direction.WEST -> WEST_Shape;
            case Direction.NORTH -> NORTH_Shape;
            case Direction.SOUTH -> SOUTH_Shape;
        };
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        BlockPos blockPos = pos.m_142300_(direction.m_122424_());
        BlockState blockState = world.m_8055_(blockPos);
        return blockState.m_60783_((BlockGetter)world, blockPos, direction);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos currentPos, BlockPos neighborPos) {
        return state.m_60710_((LevelReader)world, currentPos) ? state : Blocks.f_50016_.m_49966_();
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        BlockEntity blockEntity;
        super.m_6861_(state, world, pos, block, fromPos, notify);
        if (!world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof TileMarker) {
            TileMarker marker = (TileMarker)blockEntity;
            marker.rsReceiving = world.m_46753_(pos);
            marker.sync();
        }
    }
}

