/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.mini_quarry;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.EnchantmentLevel;
import com.yogpc.qp.machines.InvUtils;
import com.yogpc.qp.machines.PowerConfig;
import com.yogpc.qp.machines.PowerManager;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.QuarryFakePlayer;
import com.yogpc.qp.machines.QuarryMarker;
import com.yogpc.qp.machines.mini_quarry.BlockStatePredicate;
import com.yogpc.qp.machines.mini_quarry.MiniQuarryInventory;
import com.yogpc.qp.machines.mini_quarry.MiniQuarryMenu;
import com.yogpc.qp.machines.mini_quarry.MiniTarget;
import com.yogpc.qp.utils.MapMulti;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public final class MiniQuarryTile
extends PowerTile
implements CheckerLog,
EnchantmentLevel.HasEnchantments,
MenuProvider,
PowerConfig.Provider {
    private List<EnchantmentLevel> enchantments;
    @Nullable
    Area area = null;
    boolean rs;
    final MiniQuarryInventory container = new MiniQuarryInventory();
    @Nullable
    MiniTarget targetIterator;
    Collection<BlockStatePredicate> denyList = MiniQuarryTile.defaultBlackList();
    Collection<BlockStatePredicate> allowList = Set.of();

    public MiniQuarryTile(BlockPos pos, BlockState state) {
        super(Holder.MINI_QUARRY_TYPE, pos, state);
        this.container.m_19164_(c -> this.m_6596_());
    }

    void work() {
        this.container.getEnergyModule().ifPresent(e -> this.addEnergy((long)e.energy() * 1000000000L, false));
        if (!this.hasEnoughEnergy()) {
            return;
        }
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_46467_() % (long)MiniQuarryTile.interval(this.efficiencyLevel()) != 0L || this.targetIterator == null) {
            return;
        }
        if (!this.useEnergy(PowerManager.getMiniQuarryEnergy(this), PowerTile.Reason.MINI_QUARRY, false)) {
            return;
        }
        while (this.targetIterator.hasNext()) {
            BlockState state;
            BlockPos pos;
            ServerLevel level = this.getTargetWorld();
            if (!this.canBreak((Level)level, pos = this.targetIterator.next(), state = level.m_8055_(pos))) continue;
            FakePlayer fakePlayer = QuarryFakePlayer.get(level);
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent((Level)level, pos, state, (Player)fakePlayer);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
            if (state.m_60800_((BlockGetter)level, pos) < 0.0f) {
                this.useEnergy(PowerManager.getBreakEnergy(-1.0f, this), PowerTile.Reason.BREAK_BLOCK, true);
            }
            List<ItemStack> tools = this.container.tools();
            Optional<ItemStack> tool = tools.stream().filter(t -> t.m_41735_(state)).findFirst().or(() -> tools.stream().filter(t -> {
                fakePlayer.m_21008_(InteractionHand.MAIN_HAND, t);
                return ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)fakePlayer);
            }).findFirst());
            tool.ifPresent(t -> {
                fakePlayer.m_21008_(InteractionHand.MAIN_HAND, t);
                List drops = Block.m_49874_((BlockState)state, (ServerLevel)level, (BlockPos)pos, (BlockEntity)level.m_7702_(pos), (Entity)fakePlayer, (ItemStack)t);
                drops.forEach(this::insertOrDropItem);
                int damage = t.m_41735_(state) ? 1 : 4;
                for (int i = 0; i < damage; ++i) {
                    t.m_41686_((Level)level, state, pos, (Player)fakePlayer);
                }
                level.m_7471_(pos, false);
                SoundType sound = state.m_60827_();
                level.m_5594_(null, pos, sound.m_56775_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 4.0f, sound.m_56774_() * 0.8f);
            });
            if (!tool.isPresent()) continue;
            break;
        }
        if (!this.targetIterator.hasNext()) {
            this.targetIterator = null;
            this.finishWork();
        }
    }

    boolean canBreak(Level level, BlockPos pos, BlockState state) {
        if (this.allowList.stream().anyMatch(t -> t.test(state, (BlockGetter)level, pos))) {
            return true;
        }
        return state.m_60800_((BlockGetter)level, pos) >= 0.0f && this.denyList.stream().noneMatch(t -> t.test(state, (BlockGetter)level, pos));
    }

    ServerLevel getTargetWorld() {
        return (ServerLevel)this.f_58857_;
    }

    boolean isWorking() {
        return this.targetIterator != null;
    }

    void gotRSPulse() {
        if (this.isWorking()) {
            this.finishWork();
        } else {
            this.startWork();
        }
    }

    public void setArea(@Nullable Area area) {
        this.area = area;
        if (area != null) {
            this.targetIterator = MiniTarget.of(area, true);
        }
    }

    void startWork() {
        assert (this.f_58857_ != null);
        Direction behind = ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_();
        Area area = this.area == null ? (Area)Stream.of(behind, behind.m_122428_(), behind.m_122427_()).map(arg_0 -> ((BlockPos)this.m_58899_()).m_142300_(arg_0)).flatMap(p -> {
            BlockEntity patt6256$temp = this.f_58857_.m_7702_(p);
            if (patt6256$temp instanceof QuarryMarker) {
                QuarryMarker marker = (QuarryMarker)patt6256$temp;
                return Stream.of(marker);
            }
            return Stream.empty();
        }).flatMap(m -> m.getArea().stream().peek(a -> m.removeAndGetItems().forEach(this::insertOrDropItem))).findFirst().map(a -> new Area(a.minX() - 1, a.minY(), a.minZ() - 1, a.maxX() + 1, a.maxY(), a.maxZ() + 1, a.direction())).map(a -> a.aboveY(this.f_58857_.m_141937_() + 1)).orElse(null) : this.area;
        this.setArea(area);
        if (this.area != null) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)QPBlock.WORKING, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    void finishWork() {
        assert (this.f_58857_ != null);
        this.targetIterator = null;
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)QPBlock.WORKING, (Comparable)Boolean.valueOf(false)), 3);
        this.logUsage();
    }

    void insertOrDropItem(ItemStack stack) {
        assert (this.f_58857_ != null);
        ItemStack rest = InvUtils.injectToNearTile(this.f_58857_, this.m_58899_(), stack);
        if (rest.m_41619_()) {
            return;
        }
        Containers.m_18992_((Level)this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (ItemStack)rest);
    }

    @Override
    public void saveNbtData(CompoundTag nbt) {
        nbt.m_128379_("rs", this.rs);
        if (this.area != null) {
            nbt.m_128365_("area", (Tag)this.area.toNBT());
        }
        CompoundTag enchantments = new CompoundTag();
        this.enchantments.forEach(e -> enchantments.m_128405_(String.valueOf(e.enchantmentID()), e.level()));
        nbt.m_128365_("enchantments", (Tag)enchantments);
        if (this.targetIterator != null) {
            nbt.m_128356_("current", this.targetIterator.peek().m_121878_());
        }
        nbt.m_128365_("inventory", (Tag)this.container.m_7927_());
        nbt.m_128365_("denyList", (Tag)this.denyList.stream().map(BlockStatePredicate::toTag).collect(Collectors.toCollection(ListTag::new)));
        nbt.m_128365_("allowList", (Tag)this.allowList.stream().map(BlockStatePredicate::toTag).collect(Collectors.toCollection(ListTag::new)));
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.rs = nbt.m_128471_("rs");
        this.setArea(Area.fromNBT(nbt.m_128469_("area")).orElse(null));
        CompoundTag enchantments = nbt.m_128469_("enchantments");
        this.setEnchantments(enchantments.m_128431_().stream().mapMulti(MapMulti.getEntry(ForgeRegistries.ENCHANTMENTS, arg_0 -> ((CompoundTag)enchantments).m_128451_(arg_0))).map(EnchantmentLevel::new).sorted(EnchantmentLevel.QUARRY_ENCHANTMENT_COMPARATOR).toList());
        if (nbt.m_128441_("current") && this.targetIterator != null) {
            this.targetIterator.setCurrent(BlockPos.m_122022_((long)nbt.m_128454_("current")));
        }
        this.container.m_7797_(nbt.m_128437_("inventory", 10));
        this.denyList = Stream.concat(nbt.m_128437_("denyList", 10).stream().mapMulti(MapMulti.cast(CompoundTag.class)).map(BlockStatePredicate::fromTag), MiniQuarryTile.defaultBlackList().stream()).collect(Collectors.toSet());
        this.allowList = nbt.m_128437_("allowList", 10).stream().mapMulti(MapMulti.cast(CompoundTag.class)).map(BlockStatePredicate::fromTag).collect(Collectors.toSet());
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        return Stream.of("%sArea:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.area), "%sTarget:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, Optional.ofNullable(this.targetIterator).map(MiniTarget::peek).orElse(null)), this.energyString()).map(TextComponent::new).toList();
    }

    public void setEnchantments(List<EnchantmentLevel> enchantments) {
        this.enchantments = enchantments;
    }

    @Override
    public List<EnchantmentLevel> getEnchantments() {
        return this.enchantments;
    }

    Container getInv() {
        return this.container;
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new MiniQuarryMenu(id, player, this.m_58899_());
    }

    static int interval(int efficiency) {
        return switch (efficiency) {
            case 0 -> 40;
            case 1 -> 30;
            case 2 -> 20;
            case 3 -> 10;
            case 4 -> 5;
            case 5 -> 2;
            default -> efficiency < 0 ? 100 : 1;
        };
    }

    static Set<BlockStatePredicate> defaultBlackList() {
        return Set.of(BlockStatePredicate.air(), BlockStatePredicate.fluid());
    }

    static boolean canAddInList(boolean isAllowList, BlockStatePredicate newData) {
        if (isAllowList) {
            return newData != BlockStatePredicate.all() && newData != BlockStatePredicate.air();
        }
        return !MiniQuarryTile.defaultBlackList().contains(newData);
    }
}

