/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.misc;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.Direction8;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;

public class BlockDummy
extends AbstractGlassBlock {
    public static final String NAME = "dummy";
    public final BlockItem blockItem;
    private boolean breaking = false;

    public BlockDummy() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60955_().m_60993_().m_60922_((state, world, pos, type) -> false).m_60960_((state, world, pos) -> false).m_60924_((state, world, pos) -> false).m_60971_((state, world, pos) -> false));
        this.setRegistryName("quarryplus", NAME);
        this.blockItem = new BlockItem((Block)this, new Item.Properties().m_41491_(Holder.TAB));
        this.blockItem.setRegistryName("quarryplus", NAME);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60734_() != newState.m_60734_()) {
            if (!this.breaking) {
                this.breaking = true;
                this.breakChain(world, pos);
                this.breaking = false;
            }
            super.m_6810_(state, world, pos, newState, moved);
        }
    }

    private void breakChain(Level world, BlockPos first) {
        if (!world.f_46443_) {
            ArrayList<BlockPos> nextCheck = new ArrayList<BlockPos>();
            for (Direction8 dir : Direction8.DIRECTIONS) {
                BlockPos nPos = first.m_141952_(dir.vec());
                BlockState nBlock = world.m_8055_(nPos);
                if (nBlock.m_60734_() != this) continue;
                nextCheck.add(nPos);
            }
            if (!nextCheck.isEmpty()) {
                MinecraftServer server = Objects.requireNonNull(world.m_142572_());
                server.m_6937_((Runnable)new TickTask(server.m_129921_() + 4, (Runnable)new ChainBreakTask(world, nextCheck, 1, b -> {
                    this.breaking = b;
                }, new HashSet<BlockPos>())));
            }
        }
    }

    private static class ChainBreakTask
    implements Runnable {
        private final Level level;
        private final Collection<BlockPos> targets;
        private final int totalRemoved;
        private final BooleanConsumer consumer;
        private final HashSet<BlockPos> checked;

        ChainBreakTask(Level level, Collection<BlockPos> targets, int totalRemoved, BooleanConsumer consumer, HashSet<BlockPos> checked) {
            this.level = level;
            this.targets = targets;
            this.totalRemoved = totalRemoved;
            this.consumer = consumer;
            this.checked = checked;
        }

        @Override
        public void run() {
            HashSet<BlockPos> removed = new HashSet<BlockPos>();
            ArrayList<BlockPos> nextCheck = new ArrayList<BlockPos>(this.targets);
            while (!nextCheck.isEmpty() && removed.size() < 16383) {
                BlockPos[] copied = nextCheck.toArray(new BlockPos[0]);
                nextCheck.clear();
                for (BlockPos pos : copied) {
                    BlockState nBlock;
                    for (Direction8 dir : Direction8.DIRECTIONS) {
                        BlockState nBlock2;
                        BlockPos nPos = pos.m_141952_(dir.vec());
                        if (!this.checked.add(nPos) || (nBlock2 = this.level.m_8055_(nPos)).m_60734_() != Holder.BLOCK_DUMMY || !removed.add(nPos)) continue;
                        nextCheck.add(nPos);
                    }
                    if (!this.checked.add(pos) || (nBlock = this.level.m_8055_(pos)).m_60734_() != Holder.BLOCK_DUMMY) continue;
                    removed.add(pos);
                }
            }
            this.consumer.accept(true);
            removed.forEach(p -> this.level.m_7471_(p, false));
            this.consumer.accept(false);
            if (!nextCheck.isEmpty()) {
                MinecraftServer server = Objects.requireNonNull(this.level.m_142572_());
                server.m_6937_((Runnable)new TickTask(server.m_129921_() + 4, (Runnable)new ChainBreakTask(this.level, nextCheck, this.totalRemoved + removed.size(), this.consumer, this.checked)));
            }
        }
    }
}

