/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.workbench;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yogpc.qp.QuarryPlus;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.NBTIngredient;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.VisibleForTesting;

public record IngredientWithCount(Ingredient ingredient, int count) implements Predicate<ItemStack>
{
    public IngredientWithCount(JsonObject jsonObject) {
        this(CraftingHelper.getIngredient((JsonElement)IngredientWithCount.modifyCount(jsonObject)), GsonHelper.m_13927_((JsonObject)jsonObject, (String)"count"));
    }

    public IngredientWithCount(ItemStack stack) {
        this(Ingredient.m_43927_((ItemStack[])new ItemStack[]{ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1)}), stack.m_41613_());
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.ingredient.test(stack) && stack.m_41613_() >= this.count;
    }

    boolean shrink(ItemStack stack) {
        if (this.test(stack)) {
            stack.m_41774_(this.count);
            return true;
        }
        return false;
    }

    public List<ItemStack> stackList() {
        return Arrays.stream(this.ingredient.m_43908_()).filter(Predicate.not(ItemStack::m_41619_)).map(stack -> ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)this.count)).toList();
    }

    public JsonElement toJson() {
        JsonElement obj = this.ingredient.m_43942_();
        if (obj instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)obj;
            jsonArray.forEach(e -> e.getAsJsonObject().addProperty("count", (Number)this.count));
        } else if (obj instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)obj;
            jsonObject.addProperty("count", (Number)this.count);
        }
        return obj;
    }

    public void toPacket(FriendlyByteBuf buf) {
        this.ingredient.m_43923_(buf);
        buf.writeInt(this.count);
    }

    public static List<IngredientWithCount> getSeq(JsonElement jsonElement) {
        if (jsonElement instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)jsonElement;
            return StreamSupport.stream(jsonArray.spliterator(), false).map(JsonElement::getAsJsonObject).map(IngredientWithCount::new).toList();
        }
        return List.of(new IngredientWithCount(jsonElement.getAsJsonObject()));
    }

    public static IngredientWithCount fromPacket(FriendlyByteBuf buf) {
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buf);
        int count = buf.readInt();
        return new IngredientWithCount(ingredient, count);
    }

    @VisibleForTesting
    public static NBTIngredient createNbtIngredient(ItemStack stack) {
        try {
            Constructor constructor = NBTIngredient.class.getDeclaredConstructor(ItemStack.class);
            constructor.trySetAccessible();
            return (NBTIngredient)constructor.newInstance(stack);
        }
        catch (ReflectiveOperationException exception) {
            QuarryPlus.LOGGER.error("Caught error when creating NBTIngredient instance. This should not be called in production.", (Throwable)exception);
            return null;
        }
    }

    static JsonObject modifyCount(JsonObject object) {
        if (object.has("count")) {
            JsonObject clone = new JsonObject();
            object.entrySet().forEach(e -> clone.add((String)e.getKey(), (JsonElement)e.getValue()));
            clone.remove("count");
            return clone;
        }
        return object;
    }
}

