/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.utils;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class ConfigCommand {
    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        List<String> configNames = Holder.conditionHolders().stream().map(Holder.EntryConditionHolder::location).map(ResourceLocation::m_135815_).sorted().toList();
        LiteralArgumentBuilder parent = (LiteralArgumentBuilder)Commands.m_82127_((String)"quarryplus").requires(source -> source.m_6761_(2));
        LiteralArgumentBuilder configCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"config").executes(ConfigCommand::getConfigValues);
        RequiredArgumentBuilder setCommand = (RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)new SelectorArgument(configNames)).then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(c -> ConfigCommand.changeMachineSetting(SelectorArgument.getString(c, "name"), BoolArgumentType.getBool((CommandContext)c, (String)"value"), (CommandContext<CommandSourceStack>)c)));
        event.getDispatcher().register((LiteralArgumentBuilder)parent.then(configCommand.then((ArgumentBuilder)setCommand)));
    }

    private static int changeMachineSetting(String name, boolean enabled, CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        if (QuarryPlus.config != null) {
            QuarryPlus.config.enableMap.set(name, enabled);
            ((CommandSourceStack)commandContext.getSource()).m_81354_((Component)new TextComponent("%s changed to %B".formatted(name, enabled)), true);
            return 1;
        }
        SimpleCommandExceptionType supplier = new SimpleCommandExceptionType((Message)new TextComponent("QuarryPlus.config is NULL."));
        throw supplier.create();
    }

    private static int getConfigValues(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        if (QuarryPlus.config != null) {
            ((CommandSourceStack)commandContext.getSource()).m_81354_((Component)new TextComponent(String.format("%sQuarryPlus Machine List%s", ChatFormatting.UNDERLINE, ChatFormatting.RESET)), false);
            Holder.conditionHolders().stream().map(Holder.EntryConditionHolder::location).map(ResourceLocation::m_135815_).sorted().map(l -> String.format("%s%s%s: %B", ChatFormatting.DARK_AQUA, l, ChatFormatting.RESET, QuarryPlus.config.enableMap.enabled((String)l))).map(TextComponent::new).forEach(c -> ((CommandSourceStack)commandContext.getSource()).m_81354_((Component)c, false));
            return 1;
        }
        SimpleCommandExceptionType supplier = new SimpleCommandExceptionType((Message)new TextComponent("QuarryPlus.config is NULL."));
        throw supplier.create();
    }

    private record SelectorArgument(List<String> allowedValues) implements ArgumentType<String>
    {
        public String parse(StringReader reader) {
            return reader.readUnquotedString();
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return SharedSuggestionProvider.m_82970_(this.allowedValues, (SuggestionsBuilder)builder);
        }

        public Collection<String> getExamples() {
            return this.allowedValues;
        }

        static String getString(CommandContext<?> context, String name) {
            return (String)context.getArgument(name, String.class);
        }
    }
}

