/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.MachineStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;

public record ItemConverter(List<Conversion> conversions) {
    public static ItemConverter defaultInstance() {
        List<Conversion> conversions = PlatformAccess.config().convertDeepslateOres() ? List.of(new DeepslateOreConversion()) : List.of();
        return new ItemConverter(conversions);
    }

    public Stream<ItemStack> convert(ItemStack stack) {
        return this.conversions.stream().filter(conversion -> conversion.shouldApply(stack)).findAny().map(f -> f.convert(stack)).orElseGet(() -> Stream.of(stack));
    }

    public ItemConverter concat(List<Conversion> others) {
        ArrayList<Conversion> list = new ArrayList<Conversion>(this.conversions);
        list.addAll(others);
        return new ItemConverter(list);
    }

    public static class DeepslateOreConversion
    implements Conversion {
        @Override
        public Stream<ItemStack> convert(ItemStack stack) {
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            ResourceLocation newId = id.withPath(s -> s.replace("deepslate_", "").replace("_deepslate", ""));
            return BuiltInRegistries.ITEM.get(newId).map(h -> new ItemStack((Holder)h, stack.getCount(), stack.getComponentsPatch())).map(Stream::of).orElseGet(() -> Stream.of(stack));
        }

        @Override
        public boolean shouldApply(ItemStack stack) {
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            return id.getPath().contains("deepslate") && id.getPath().contains("ore");
        }
    }

    public static interface Conversion {
        public Stream<ItemStack> convert(ItemStack var1);

        public boolean shouldApply(ItemStack var1);
    }

    public record ToEmptyConverter(Collection<MachineStorage.ItemKey> itemKeys) implements Conversion
    {
        @Override
        public Stream<ItemStack> convert(ItemStack stack) {
            return Stream.empty();
        }

        @Override
        public boolean shouldApply(ItemStack stack) {
            MachineStorage.ItemKey key = MachineStorage.ItemKey.of(stack);
            return this.itemKeys.contains(key);
        }
    }

    public static class ChunkDestroyerConversion
    implements Conversion {
        @Override
        public Stream<ItemStack> convert(ItemStack stack) {
            return Stream.empty();
        }

        @Override
        public boolean shouldApply(ItemStack stack) {
            if (stack.is(ItemTags.DIRT) || stack.is(Items.COBBLESTONE) || stack.is(Items.SANDSTONE) || stack.is(Items.RED_SANDSTONE)) {
                return true;
            }
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                BlockState state = blockItem.getBlock().defaultBlockState();
                return state.is(BlockTags.BASE_STONE_OVERWORLD) || state.is(BlockTags.BASE_STONE_NETHER);
            }
            return false;
        }
    }
}

