/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine;

import com.yogpc.qp.machine.MachineStorage;
import java.util.Optional;
import java.util.ServiceLoader;

public interface MachineStorageHolder<T> {
    public MachineStorage getMachineStorage(T var1);

    public Class<T> supportingClass();

    public static <T> Optional<MachineStorageHolder<T>> getHolder(T object) {
        if (object == null) {
            return Optional.empty();
        }
        for (MachineStorageHolder holder : ServiceLoader.load(MachineStorageHolder.class)) {
            if (!holder.supportingClass().isAssignableFrom(object.getClass())) continue;
            return Optional.of(holder);
        }
        return Optional.empty();
    }

    public static class ForConstant
    implements MachineStorageHolder<Constant> {
        @Override
        public MachineStorage getMachineStorage(Constant instance) {
            return instance.storage;
        }

        @Override
        public Class<Constant> supportingClass() {
            return Constant.class;
        }
    }

    public record Constant(MachineStorage storage) {
    }
}

