/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.advquarry;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.Area;
import com.yogpc.qp.machine.advquarry.AdvActionActionMessage;
import com.yogpc.qp.machine.advquarry.AdvActionSyncMessage;
import com.yogpc.qp.machine.advquarry.AdvQuarryContainer;
import com.yogpc.qp.machine.advquarry.AdvQuarryEntity;
import com.yogpc.qp.machine.advquarry.AdvQuarryState;
import com.yogpc.qp.machine.advquarry.WorkConfig;
import com.yogpc.qp.machine.misc.IndexedButton;
import com.yogpc.qp.machine.misc.SmallCheckBox;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.ChunkPos;

public class AdvQuarryScreen
extends AbstractContainerScreen<AdvQuarryContainer> {
    private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)"textures/gui/adv_quarry.png");
    private SmallCheckBox areaFrameCheckBox;
    private SmallCheckBox chunkByChunkCheckBox;
    private SmallCheckBox startCheckBox;
    private final List<MovablePosition> movablePositions = new ArrayList<MovablePosition>();

    public AdvQuarryScreen(AdvQuarryContainer c, Inventory inventory, Component component) {
        super((AbstractContainerMenu)c, inventory, component);
        this.imageWidth = c.imageWidth;
        this.imageHeight = c.imageHeight;
        this.inventoryLabelY = this.imageHeight - 96 + 2;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        int pX = this.leftPos;
        int pY = this.topPos;
        graphics.blit(RenderPipelines.GUI_TEXTURED, LOCATION, pX, pY, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        Area range = ((AdvQuarryContainer)this.getMenu()).quarry.getArea();
        if (range != null) {
            ChunkPos chunkPos = new ChunkPos(((AdvQuarryContainer)this.getMenu()).quarry.getBlockPos());
            for (MovablePosition movablePosition : this.movablePositions) {
                graphics.drawString(this.font, String.valueOf(movablePosition.distance(chunkPos, range) / 16.0), movablePosition.baseX, movablePosition.baseY, ARGB.opaque((int)0x404040), false);
            }
        }
    }

    protected void init() {
        super.init();
        this.movablePositions.add(new MovablePosition(Direction.NORTH, 77, 18));
        this.movablePositions.add(new MovablePosition(Direction.SOUTH, 77, 62));
        this.movablePositions.add(new MovablePosition(Direction.WEST, 24, 40));
        this.movablePositions.add(new MovablePosition(Direction.EAST, 131, 40));
        for (MovablePosition movablePosition : this.movablePositions) {
            for (DiffPosition diffPosition : DiffPosition.values()) {
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)diffPosition.text, (Button.OnPress)this.areaChange(movablePosition, diffPosition)).pos(this.leftPos + movablePosition.buttonX(diffPosition), this.topPos + movablePosition.buttonY()).size(12, 8).build());
            }
        }
        this.addRenderableWidget((GuiEventListener)new IndexedButton(8, this.leftPos + 118, this.topPos + 58, 50, 12, (Component)Component.literal((String)"Start"), this::startQuarryOnPress));
        if (!PlatformAccess.getAccess().platformName().equalsIgnoreCase("fabric")) {
            this.addRenderableWidget((GuiEventListener)new IndexedButton(9, this.leftPos + 8, this.topPos + 58, 50, 12, (Component)Component.literal((String)"Modules"), this::openModuleOnPress));
        }
        this.areaFrameCheckBox = new SmallCheckBox(this.leftPos + 8, this.topPos + 72, 100, 10, 10, 10, (Component)Component.literal((String)"Area Frame"), ((AdvQuarryContainer)this.getMenu()).quarry.workConfig.placeAreaFrame(), this::checkBoxOnPress);
        this.addRenderableWidget((GuiEventListener)this.areaFrameCheckBox);
        this.chunkByChunkCheckBox = new SmallCheckBox(this.leftPos + 8, this.topPos + 83, 100, 10, 10, 10, (Component)Component.literal((String)"Chunk by Chunk"), ((AdvQuarryContainer)this.getMenu()).quarry.workConfig.chunkByChunk(), this::checkBoxOnPress);
        this.addRenderableWidget((GuiEventListener)this.chunkByChunkCheckBox);
        this.startCheckBox = new SmallCheckBox(this.leftPos + 8, this.topPos + 94, 100, 10, 10, 10, (Component)Component.literal((String)"Ready to Start"), ((AdvQuarryContainer)this.getMenu()).quarry.workConfig.startImmediately(), this::checkBoxOnPress);
        this.addRenderableWidget((GuiEventListener)this.startCheckBox);
    }

    private void startQuarryOnPress(Button b) {
        AdvQuarryEntity quarry = ((AdvQuarryContainer)this.getMenu()).quarry;
        if (quarry.currentState == AdvQuarryState.WAITING) {
            quarry.workConfig = quarry.workConfig.startSoonConfig();
            this.startCheckBox.setSelected(quarry.workConfig.startImmediately());
            PlatformAccess.getAccess().packetHandler().sendToServer(new AdvActionActionMessage(quarry, AdvActionActionMessage.Action.QUICK_START));
            PlatformAccess.getAccess().packetHandler().sendToServer(new AdvActionSyncMessage(quarry, false));
        }
    }

    private void openModuleOnPress(Button b) {
        AdvQuarryEntity quarry = ((AdvQuarryContainer)this.getMenu()).quarry;
        PlatformAccess.getAccess().packetHandler().sendToServer(new AdvActionActionMessage(quarry, AdvActionActionMessage.Action.MODULE_INV));
    }

    private void checkBoxOnPress(Button b) {
        AdvQuarryEntity quarry = ((AdvQuarryContainer)this.getMenu()).quarry;
        if (quarry.currentState == AdvQuarryState.WAITING) {
            boolean placeAreaFrame = this.areaFrameCheckBox.isSelected();
            boolean chunkByChunk = this.chunkByChunkCheckBox.isSelected();
            boolean startImmediately = this.startCheckBox.isSelected();
            quarry.workConfig = new WorkConfig(startImmediately, placeAreaFrame, chunkByChunk);
            PlatformAccess.getAccess().packetHandler().sendToServer(new AdvActionSyncMessage(quarry, false));
        }
    }

    private Button.OnPress areaChange(MovablePosition movablePosition, DiffPosition diffPosition) {
        return b -> {
            AdvQuarryEntity quarry = ((AdvQuarryContainer)this.getMenu()).quarry;
            if (quarry.currentState != AdvQuarryState.WAITING) {
                return;
            }
            Direction direction = movablePosition.direction;
            int increase = diffPosition.sign;
            boolean shift = Minecraft.getInstance().hasShiftDown();
            boolean ctrl = Minecraft.getInstance().hasControlDown();
            int t = shift && ctrl ? 1024 * increase : (shift ? 256 * increase : (ctrl ? 64 * increase : 16 * increase));
            Area range = quarry.getArea();
            if (range == null) {
                return;
            }
            Area newRange = switch (direction.getAxis()) {
                case Direction.Axis.X -> {
                    int e;
                    switch (direction.getAxisDirection()) {
                        case POSITIVE: {
                            e = range.maxX();
                            if (range.minX() < e + t) {
                                yield new Area(range.minX(), range.minY(), range.minZ(), e + t, range.maxY(), range.maxZ(), range.direction());
                            }
                            yield range;
                        }
                        case NEGATIVE: {
                            e = range.minX();
                            if (range.maxX() > e - t) {
                                yield new Area(e - t, range.minY(), range.minZ(), range.maxX(), range.maxY(), range.maxZ(), range.direction());
                            }
                            yield range;
                        }
                    }
                    yield range;
                }
                case Direction.Axis.Z -> {
                    int e;
                    switch (direction.getAxisDirection()) {
                        case POSITIVE: {
                            e = range.maxZ();
                            if (range.minZ() < e + t) {
                                yield new Area(range.minX(), range.minY(), range.minZ(), range.maxX(), range.maxY(), e + t, range.direction());
                            }
                            yield range;
                        }
                        case NEGATIVE: {
                            e = range.minZ();
                            if (range.maxZ() > e - t) {
                                yield new Area(range.minX(), range.minY(), e - t, range.maxX(), range.maxY(), range.maxZ(), range.direction());
                            }
                            yield range;
                        }
                    }
                    yield range;
                }
                default -> range;
            };
            quarry.setArea(newRange);
            PlatformAccess.getAccess().packetHandler().sendToServer(new AdvActionSyncMessage(quarry, true));
        };
    }

    private record MovablePosition(Direction direction, int baseX, int baseY) {
        int buttonX(DiffPosition diffPosition) {
            return switch (diffPosition.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.plusButtonX();
                case 1 -> this.minusButtonX();
            };
        }

        int minusButtonX() {
            return this.baseX - 13;
        }

        int plusButtonX() {
            return this.baseX + 22;
        }

        int buttonY() {
            return this.baseY - 1;
        }

        double distance(ChunkPos quarryChunk, Area area) {
            Direction direction = this.direction;
            int n = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"NORTH", "SOUTH", "WEST", "EAST"}, (Direction)direction, n)) {
                case 0 -> quarryChunk.getMinBlockZ() - area.minZ() - 1;
                case 1 -> area.maxZ() - quarryChunk.getMaxBlockZ() - 1;
                case 2 -> quarryChunk.getMinBlockX() - area.minX() - 1;
                case 3 -> area.maxX() - quarryChunk.getMaxBlockX() - 1;
                default -> 0.0;
            };
        }
    }

    private static enum DiffPosition {
        PLUS((Component)Component.literal((String)"+"), 1),
        MINUS((Component)Component.literal((String)"-"), -1);

        private final Component text;
        private final int sign;

        private DiffPosition(Component text, int sign) {
            this.text = text;
            this.sign = sign;
        }
    }
}

