/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.marker;

import com.yogpc.qp.machine.Area;
import com.yogpc.qp.machine.QpEntity;
import com.yogpc.qp.machine.marker.QuarryMarker;
import com.yogpc.qp.packet.ClientSync;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class ChunkMarkerEntity
extends QpEntity
implements QuarryMarker,
ClientSync {
    @NotNull
    private Direction.AxisDirection xDirection = Direction.AxisDirection.POSITIVE;
    @NotNull
    private Direction.AxisDirection zDirection = Direction.AxisDirection.POSITIVE;
    int size = 16;
    int minY;
    int maxY;

    public ChunkMarkerEntity(BlockPos pos, BlockState blockState) {
        super(pos, blockState);
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.fromClientTag(input);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        this.toClientTag(output);
    }

    @Override
    public void fromClientTag(ValueInput input) {
        this.xDirection = input.getString("xDirection").map(Direction.AxisDirection::valueOf).orElse(this.xDirection);
        this.zDirection = input.getString("zDirection").map(Direction.AxisDirection::valueOf).orElse(this.zDirection);
        this.size = input.getIntOr("size", this.size);
        this.minY = input.getIntOr("minY", this.minY);
        this.maxY = input.getIntOr("maxY", this.maxY);
    }

    @Override
    public ValueOutput toClientTag(ValueOutput output) {
        output.putString("xDirection", this.xDirection.name());
        output.putString("zDirection", this.zDirection.name());
        output.putInt("size", this.size);
        output.putInt("minY", this.minY);
        output.putInt("maxY", this.maxY);
        return output;
    }

    @Override
    public Stream<MutableComponent> checkerLogs() {
        return Stream.concat(super.checkerLogs(), Stream.of(ChunkMarkerEntity.detail(ChatFormatting.GREEN, "xDirection", String.valueOf(this.xDirection)), ChunkMarkerEntity.detail(ChatFormatting.GREEN, "zDirection", String.valueOf(this.zDirection)), ChunkMarkerEntity.detail(ChatFormatting.GREEN, "size", String.valueOf(this.size)), ChunkMarkerEntity.detail(ChatFormatting.GREEN, "minY", String.valueOf(this.minY)), ChunkMarkerEntity.detail(ChatFormatting.GREEN, "maxY", String.valueOf(this.maxY))));
    }

    @Override
    public Optional<QuarryMarker.Link> getLink() {
        return Optional.of(this.createLink());
    }

    Link createLink() {
        ItemStack stack = new ItemStack((ItemLike)this.getBlockState().getBlock());
        return new Link(this.getBlockPos(), this.xDirection.getStep() * (this.size + 1), this.zDirection.getStep() * (this.size + 1), this.minY, this.maxY, stack);
    }

    public void init(Direction.AxisDirection xDirection, Direction.AxisDirection zDirection) {
        this.xDirection = Objects.requireNonNull(xDirection);
        this.zDirection = Objects.requireNonNull(zDirection);
        this.changeSize(this.size);
    }

    public void changeSize(int size) {
        int y = this.getBlockPos().getY();
        this.changeSize(size, y, y);
    }

    public void changeSize(int size, int minY, int maxY) {
        this.size = size;
        this.minY = minY;
        this.maxY = maxY;
    }

    public AABB getRenderAabb() {
        Link link = this.createLink();
        Area area = link.area();
        return new AABB((double)area.minX(), (double)area.minY(), (double)area.minZ(), (double)area.maxX(), (double)area.maxY(), (double)area.maxZ());
    }

    record Link(BlockPos basePos, int xOffset, int zOffset, int minY, int maxY, ItemStack drop) implements QuarryMarker.Link
    {
        @Override
        public Area area() {
            int x2 = this.basePos.getX() + this.xOffset;
            int z2 = this.basePos.getZ() + this.zOffset;
            return new Area(Math.min(this.basePos.getX(), x2), this.minY, Math.min(this.basePos.getZ(), z2), Math.max(this.basePos.getX(), x2), this.maxY, Math.max(this.basePos.getZ(), z2), Direction.UP);
        }

        @Override
        public void remove(Level level) {
            level.removeBlock(this.basePos, false);
        }

        @Override
        public List<ItemStack> drops() {
            return List.of(this.drop);
        }
    }
}

