/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.marker;

import com.yogpc.qp.machine.GeneralScreenHandler;
import com.yogpc.qp.machine.QpEntity;
import com.yogpc.qp.machine.marker.ExMarkerBlock;
import com.yogpc.qp.machine.marker.FlexibleMarkerEntity;
import com.yogpc.qp.machine.marker.MarkerContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public final class FlexibleMarkerBlock
extends ExMarkerBlock {
    public static final String NAME = "flexible_marker";

    public FlexibleMarkerBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.NONE).pushReaction(PushReaction.DESTROY).instabreak().lightLevel(value -> 7).noCollision(), NAME);
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        float rotationYawHead = placer != null ? placer.getYHeadRot() : 0.0f;
        Direction direction = Direction.fromYRot((double)rotationYawHead);
        this.getBlockEntityType().map(e -> (FlexibleMarkerEntity)e.getBlockEntity((BlockGetter)level, pos)).ifPresent(m -> m.init(direction));
    }

    @Override
    protected GeneralScreenHandler<?> getScreenHandler(QpEntity entity) {
        return new GeneralScreenHandler<MarkerContainer>(entity, MarkerContainer::createFlexibleMarkerContainer);
    }
}

