/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.mover;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machine.misc.IndexedButton;
import com.yogpc.qp.machine.mover.MoverContainer;
import com.yogpc.qp.machine.mover.MoverMessage;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.Nullable;

public final class MoverScreen
extends AbstractContainerScreen<MoverContainer> {
    private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)"textures/gui/mover.png");
    private static final WidgetSprites PAGE_FORWARD_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/page_forward"), ResourceLocation.withDefaultNamespace((String)"recipe_book/page_forward_highlighted"));
    private static final WidgetSprites PAGE_BACKWARD_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/page_backward"), ResourceLocation.withDefaultNamespace((String)"recipe_book/page_backward_highlighted"));
    private IndexedButton enchantmentMoveButton;
    private StateSwitchingButton forwardButton;
    private StateSwitchingButton backwardButton;
    private int currentIndex = 0;

    public MoverScreen(MoverContainer menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 186;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int pX = this.leftPos;
        int pY = this.topPos;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, LOCATION, pX, pY, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
    }

    protected void init() {
        super.init();
        int width = 120;
        this.enchantmentMoveButton = new IndexedButton(1, this.leftPos + (this.imageWidth - 120) / 2, this.topPos + 38, 120, 20, (Component)Component.empty(), this::onPress);
        this.addRenderableWidget((GuiEventListener)this.enchantmentMoveButton);
        this.backwardButton = new ArrowButton(this.leftPos + (this.imageWidth - 12) / 2 - 20, this.enchantmentMoveButton.getY() + this.enchantmentMoveButton.getHeight() + 8, 12, 17, false, PAGE_BACKWARD_SPRITES, this::onPress);
        this.addRenderableWidget((GuiEventListener)this.backwardButton);
        this.forwardButton = new ArrowButton(this.leftPos + (this.imageWidth - 12) / 2 + 20, this.enchantmentMoveButton.getY() + this.enchantmentMoveButton.getHeight() + 8, 12, 17, false, PAGE_FORWARD_SPRITES, this::onPress);
        this.addRenderableWidget((GuiEventListener)this.forwardButton);
        this.enchantmentMoveButton.setTooltip(Tooltip.create((Component)Component.literal((String)"Move this enchantment")));
        this.backwardButton.setTooltip(Tooltip.create((Component)Component.literal((String)"Previous")));
        this.forwardButton.setTooltip(Tooltip.create((Component)Component.literal((String)"Next")));
    }

    public void onPress(AbstractWidget button) {
        List<Holder<Enchantment>> list = ((MoverContainer)this.getMenu()).entity.movableEnchantments;
        if (!button.active || list.isEmpty()) {
            return;
        }
        if (button == this.enchantmentMoveButton) {
            Holder<Enchantment> enchantment = list.get(Math.floorMod(this.currentIndex, list.size()));
            enchantment.unwrapKey().ifPresentOrElse(key -> PlatformAccess.getAccess().packetHandler().sendToServer(new MoverMessage(((MoverContainer)this.getMenu()).entity, (ResourceKey<Enchantment>)key)), () -> QuarryPlus.LOGGER.warn("No enchantment key found for {}", (Object)enchantment));
        } else if (button == this.forwardButton) {
            this.currentIndex = Math.floorMod(this.currentIndex + 1, list.size());
        } else if (button == this.backwardButton) {
            this.currentIndex = Math.floorMod(this.currentIndex - 1, list.size());
        }
    }

    protected void containerTick() {
        super.containerTick();
        List<Holder<Enchantment>> list = ((MoverContainer)this.getMenu()).entity.movableEnchantments;
        if (!list.isEmpty()) {
            this.enchantmentMoveButton.setMessage(((Enchantment)list.get(Math.floorMod(this.currentIndex, list.size())).value()).description());
        } else {
            this.enchantmentMoveButton.setMessage((Component)Component.empty());
        }
    }

    private static final class ArrowButton
    extends StateSwitchingButton {
        private final Consumer<ArrowButton> onPress;

        public ArrowButton(int x, int y, int width, int height, boolean initialState, @Nullable WidgetSprites sprites, Consumer<ArrowButton> onPress) {
            super(x, y, width, height, initialState);
            this.onPress = onPress;
            this.initTextureValues(sprites);
        }

        public void onClick(MouseButtonEvent event, boolean isDoubleClick) {
            super.onClick(event, isDoubleClick);
            this.onPress.accept(this);
        }

        public boolean isHoveredOrFocused() {
            return this.isHovered();
        }
    }
}

