/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.storage;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.GeneralScreenHandler;
import com.yogpc.qp.machine.QpBlock;
import com.yogpc.qp.machine.QpBlockItem;
import com.yogpc.qp.machine.QpEntityBlock;
import com.yogpc.qp.machine.storage.DebugStorageContainer;
import com.yogpc.qp.machine.storage.DebugStorageEntity;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public final class DebugStorageBlock
extends QpEntityBlock {
    public static final String NAME = "debug_storage";

    public DebugStorageBlock() {
        super(BlockBehaviour.Properties.of().noLootTable(), NAME, (Function<? super QpBlock, ? extends QpBlockItem>)((Function<QpBlock, QpBlockItem>)b -> new QpBlockItem((QpBlock)b, new Item.Properties())));
    }

    @Override
    protected QpBlock createBlock(BlockBehaviour.Properties properties) {
        return new DebugStorageBlock();
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DebugStorageEntity) {
            DebugStorageEntity storage = (DebugStorageEntity)blockEntity;
            if (!level.isClientSide()) {
                PlatformAccess.getAccess().openGui((ServerPlayer)player, new GeneralScreenHandler<DebugStorageContainer>(storage, DebugStorageContainer::new));
            }
            return InteractionResult.SUCCESS_SERVER;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.literal((String)"Insertion Only. No extraction"));
        tooltipComponents.add((Component)Component.literal((String)"Just for debug").withStyle(ChatFormatting.RED));
    }
}

